/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Styling.JMColor;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Boxable;
import com.jmathanim.Utils.CircularArrayList;
import com.jmathanim.Utils.EmptyRect;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.CanonicalJMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Stateable;
import com.jmathanim.mathobjects.updateableObjects.Updateable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JMPath
implements Updateable,
Stateable,
Boxable,
Iterable<JMPathPoint> {
    public static final int MATHOBJECT = 1;
    public static final int SVG_PATH = 2;
    public static final int CONNECTED_COMPONENT = 3;
    public final CircularArrayList<JMPathPoint> jmPathPoints = new CircularArrayList();
    public final CircularArrayList<Boolean> visiblePoints;
    public int pathType;
    private JMPath pathBackup;

    public JMPath() {
        this(new ArrayList<Point>());
    }

    public static JMPath make(JMPathPoint ... jmps) {
        JMPath resul = new JMPath();
        resul.addJMPoint(jmps);
        return resul;
    }

    public JMPath(ArrayList<Point> points) {
        for (Point p : points) {
            this.jmPathPoints.add(new JMPathPoint(p, true, JMPathPoint.JMPathPointType.VERTEX));
        }
        this.visiblePoints = new CircularArrayList();
        this.pathType = 1;
    }

    public ArrayList<Point> getPoints() {
        ArrayList<Point> resul = new ArrayList<Point>();
        for (JMPathPoint jmp : this.jmPathPoints) {
            resul.add(jmp.p);
        }
        return resul;
    }

    public int size() {
        return this.jmPathPoints.size();
    }

    public void addPoint(Point ... points) {
        for (Point p : points) {
            this.jmPathPoints.add(new JMPathPoint(p, true, JMPathPoint.JMPathPointType.VERTEX));
        }
    }

    public void addJMPoint(JMPathPoint ... points) {
        this.jmPathPoints.addAll(Arrays.asList(points));
    }

    public void addCPoint1(Point e) {
        this.jmPathPoints.get((int)(this.jmPathPoints.size() - 1)).cpExit.v.copyFrom(e.v);
    }

    public void addCPoint2(Point e) {
        this.jmPathPoints.get((int)(this.jmPathPoints.size() - 1)).cpEnter.v.copyFrom(e.v);
    }

    public void clear() {
        this.jmPathPoints.clear();
    }

    public void removeInterpolationPoints() {
        ArrayList<JMPathPoint> toRemove = new ArrayList<JMPathPoint>();
        for (JMPathPoint p : this.jmPathPoints) {
            if (p.type != JMPathPoint.JMPathPointType.INTERPOLATION_POINT) continue;
            toRemove.add(p);
        }
        this.jmPathPoints.removeAll(toRemove);
        for (JMPathPoint p : this.jmPathPoints) {
            if (p.cpExitvBackup != null) {
                p.cpExit.v.copyFrom(p.cpExitvBackup);
                p.cpExitvBackup = null;
            }
            if (p.cpEntervBackup == null) continue;
            p.cpEnter.v.copyFrom(p.cpEntervBackup);
            p.cpEntervBackup = null;
        }
    }

    public String toString() {
        String resul = "#" + this.jmPathPoints.size() + ":  ";
        int counter = 0;
        for (JMPathPoint p : this.jmPathPoints) {
            resul = resul + "< " + counter + " " + p.toString() + "> ";
            ++counter;
        }
        return resul;
    }

    public void addJMPointsFrom(JMPath jmpathTemp) {
        this.jmPathPoints.addAll(jmpathTemp.jmPathPoints);
    }

    public void alignPathsToGivenNumberOfElements(int newNumPoints) {
        if (newNumPoints <= this.size()) {
            return;
        }
        ArrayList<JMPathPoint> pointsToInterpolate = new ArrayList<JMPathPoint>();
        for (int n = 1; n < 1 + this.jmPathPoints.size(); ++n) {
            JMPathPoint p = this.jmPathPoints.get(n);
            if (!p.isThisSegmentVisible) continue;
            pointsToInterpolate.add(p);
        }
        int numVisibleSegments = pointsToInterpolate.size();
        int numPoints = this.jmPathPoints.size();
        int toCreate = newNumPoints - numPoints;
        int numDivs = toCreate / numVisibleSegments;
        int rest = toCreate % numVisibleSegments;
        for (int n = 0; n < pointsToInterpolate.size(); ++n) {
            JMPathPoint p = (JMPathPoint)pointsToInterpolate.get(n);
            p.numDivisions = numDivs + 1;
            p.numDivisions = p.numDivisions + (n < rest ? 1 : 0);
        }
        for (JMPathPoint p : pointsToInterpolate) {
            int k = this.jmPathPoints.indexOf(p);
            this.dividePathSegment(k, p.numDivisions);
        }
    }

    public synchronized void dividePathSegment(int k, int numDivForThisVertex) {
        if (numDivForThisVertex < 2) {
            return;
        }
        double alpha = 1.0 / (double)numDivForThisVertex;
        this.interpolateBetweenTwoPoints(k, alpha);
        this.dividePathSegment(k + 1, numDivForThisVertex - 1);
    }

    public JMPathPoint interpolateBetweenTwoPoints(int k, double alpha) {
        JMPathPoint interpolate;
        JMPathPoint jmp1 = this.jmPathPoints.get(k - 1);
        JMPathPoint jmp2 = this.jmPathPoints.get(k);
        if (jmp2.isCurved) {
            Point E = jmp1.p.interpolate(jmp1.cpExit, alpha);
            Point G = jmp2.cpEnter.interpolate(jmp2.p, alpha);
            Point F = jmp1.cpExit.interpolate(jmp2.cpEnter, alpha);
            Point H = E.interpolate(F, alpha);
            Point J = F.interpolate(G, alpha);
            Point K = H.interpolate(J, alpha);
            interpolate = new JMPathPoint(K, jmp2.isThisSegmentVisible, JMPathPoint.JMPathPointType.INTERPOLATION_POINT);
            interpolate.cpExit.v.copyFrom(J.v);
            interpolate.cpEnter.v.copyFrom(H.v);
            if (jmp1.cpExitvBackup == null) {
                jmp1.cpExitvBackup = jmp1.cpExit.v;
            }
            if (jmp2.cpEntervBackup == null) {
                jmp2.cpEntervBackup = jmp2.cpEnter.v;
            }
            jmp1.cpExit.v.copyFrom(E.v);
            jmp2.cpEnter.v.copyFrom(G.v);
        } else {
            Point interP = new Point(jmp1.p.v.interpolate(jmp2.p.v, alpha));
            interpolate = new JMPathPoint(interP, jmp2.isThisSegmentVisible, JMPathPoint.JMPathPointType.INTERPOLATION_POINT);
        }
        interpolate.isCurved = jmp2.isCurved;
        this.jmPathPoints.add(k, interpolate);
        return interpolate;
    }

    public JMPathPoint getJMPointAt(double alpha) {
        while (alpha > 1.0) {
            alpha -= 1.0;
        }
        while (alpha < 0.0) {
            alpha += 1.0;
        }
        double size = this.jmPathPoints.get((int)0).isThisSegmentVisible ? alpha * (double)this.size() : alpha * (double)(this.size() - 1);
        int k = (int)Math.floor(size);
        double t = size - (double)k;
        JMPathPoint v1 = this.jmPathPoints.get(k);
        JMPathPoint v2 = this.jmPathPoints.get(k + 1);
        JMPathPoint resul = JMPath.getJMPointBetween(v1, v2, t);
        return resul;
    }

    public static JMPathPoint getJMPointBetween(JMPathPoint v1, JMPathPoint v2, double t) {
        Point E = v1.p.interpolate(v1.cpExit, t);
        Point G = v2.cpEnter.interpolate(v2.p, t);
        Point F = v1.cpExit.interpolate(v2.cpEnter, t);
        Point H = E.interpolate(F, t);
        Point J = F.interpolate(G, t);
        JMPathPoint resul = JMPathPoint.curveTo(H.interpolate(J, t));
        resul.cpExit.copyFrom(J);
        resul.cpEnter.copyFrom(H);
        return resul;
    }

    public JMPath copy() {
        JMPath resul = new JMPath();
        for (int n = 0; n < this.jmPathPoints.size(); ++n) {
            resul.addJMPoint(this.jmPathPoints.get(n).copy());
        }
        resul.pathType = this.pathType;
        return resul;
    }

    public JMPath referencedCopy() {
        JMPath resul = new JMPath();
        resul.jmPathPoints.addAll(this.jmPathPoints);
        resul.pathType = this.pathType;
        return resul;
    }

    public void cyclePoints(int step, boolean reverse) {
        int n;
        this.distille();
        JMPath tempPath = this.referencedCopy();
        this.jmPathPoints.clear();
        int direction = reverse ? -1 : 1;
        int size = tempPath.size();
        boolean[] curveds = new boolean[size];
        boolean[] visibles = new boolean[size];
        for (n = 0; n < size; ++n) {
            curveds[n] = tempPath.jmPathPoints.get((int)n).isCurved;
            visibles[n] = tempPath.jmPathPoints.get((int)n).isThisSegmentVisible;
        }
        for (n = 0; n < size; ++n) {
            int k = direction * n + step;
            JMPathPoint point = tempPath.jmPathPoints.get(k);
            if (reverse) {
                double cpTempX = point.cpExit.v.x;
                double cpTempY = point.cpExit.v.y;
                double cpTempZ = point.cpExit.v.z;
                point.cpExit.v.copyFrom(point.cpEnter.v);
                point.cpEnter.v.x = cpTempX;
                point.cpEnter.v.y = cpTempY;
                point.cpEnter.v.z = cpTempZ;
                point.isCurved = curveds[(k + 1 + size) % size];
                point.isThisSegmentVisible = visibles[(k + 1 + size) % size];
            }
            this.jmPathPoints.add(point);
        }
    }

    public void reverse() {
        this.cyclePoints(-1, true);
    }

    public Double sumDistance(JMPath path2) {
        if (this.size() != path2.size()) {
            return null;
        }
        double resul = 0.0;
        double sum = 0.0;
        for (int n = 0; n < this.size(); ++n) {
            Vec v1 = this.jmPathPoints.get((int)n).p.v;
            Vec v2 = path2.jmPathPoints.get((int)n).p.v;
            double dist = v1.minus(v2).norm();
            sum += dist;
        }
        resul = sum /= (double)this.size();
        return resul;
    }

    void shift(Vec shiftVector) {
        for (JMPathPoint p : this.jmPathPoints) {
            p.shift(shiftVector);
        }
    }

    public double getWidth() {
        Rect r = this.getBoundingBox();
        if (r == null) {
            return 0.0;
        }
        return r.getWidth();
    }

    public double getHeight() {
        Rect r = this.getBoundingBox();
        if (r == null) {
            return 0.0;
        }
        return r.getHeight();
    }

    public ArrayList<Point> getCriticalPoints() {
        ArrayList<Point> criticalPoints = new ArrayList<Point>();
        for (int n = 0; n < this.jmPathPoints.size(); ++n) {
            JMPathPoint jmp = this.jmPathPoints.get(n);
            if (!jmp.isThisSegmentVisible) continue;
            if (jmp.isCurved) {
                criticalPoints.addAll(this.getCriticalPoints(this.jmPathPoints.get(n - 1), jmp));
            }
            criticalPoints.add(jmp.p);
        }
        return criticalPoints;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.jmPathPoints.isEmpty()) {
            return new EmptyRect();
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (JMPathPoint jmp : this.jmPathPoints) {
            points.add((Point)jmp.p.copy().thickness(2.0));
        }
        points.addAll(this.getCriticalPoints());
        return Rect.make(points);
    }

    @Override
    public boolean isEmpty() {
        return this.jmPathPoints.isEmpty();
    }

    public int getOrientation() {
        int nmax = 0;
        double ymin = this.jmPathPoints.get((int)0).p.v.y;
        double xmax = this.jmPathPoints.get((int)0).p.v.x;
        for (int n = 0; n < this.jmPathPoints.size(); ++n) {
            double y0 = this.jmPathPoints.get((int)n).p.v.y;
            double x0 = this.jmPathPoints.get((int)n).p.v.x;
            if (!(y0 < ymin) && (ymin != y0 || !(x0 > xmax))) continue;
            ymin = y0;
            xmax = x0;
            nmax = n;
        }
        Vec A = this.jmPathPoints.get((int)nmax).p.v;
        Vec B = this.jmPathPoints.get((int)(nmax - 1)).p.v;
        Vec C = this.jmPathPoints.get((int)(nmax + 1)).p.v;
        Vec AB = B.minus(A);
        Vec AC = C.minus(A);
        double cross = AB.cross((Vec)AC).z;
        int resul = Math.signum(cross) < 0.0 ? -1 : 1;
        return resul;
    }

    @Override
    public int getUpdateLevel() {
        int resul = -1;
        for (JMPathPoint p : this.jmPathPoints) {
            resul = Math.max(resul, p.getUpdateLevel());
        }
        return resul;
    }

    @Override
    public void update(JMathAnimScene scene) {
    }

    public void setJMPoints(JMPath path) {
        this.clear();
        this.addJMPointsFrom(path.copy());
        this.pathType = path.pathType;
        this.visiblePoints.clear();
        this.visiblePoints.addAll(path.visiblePoints);
    }

    @Override
    public void restoreState() {
        for (JMPathPoint p : this.jmPathPoints) {
            p.restoreState();
        }
        this.pathType = this.pathBackup.pathType;
        this.visiblePoints.clear();
        this.visiblePoints.addAll(this.pathBackup.visiblePoints);
    }

    @Override
    public void saveState() {
        this.pathBackup = new JMPath();
        for (JMPathPoint p : this.jmPathPoints) {
            p.saveState();
        }
        this.pathBackup.pathType = this.pathType;
        this.pathBackup.visiblePoints.clear();
        this.pathBackup.visiblePoints.addAll(this.pathBackup.visiblePoints);
    }

    public CanonicalJMPath canonicalForm() {
        if (this.size() == 0) {
            return new CanonicalJMPath();
        }
        ArrayList<JMPath> resul = new ArrayList<JMPath>();
        JMPath workPath = this.referencedCopy();
        Integer offset = null;
        for (int n = 0; n < this.jmPathPoints.size(); ++n) {
            JMPathPoint p = this.jmPathPoints.get(-n);
            if (p.isThisSegmentVisible) continue;
            offset = n;
            break;
        }
        if (offset == null) {
            workPath.separate(0);
            offset = -1;
        }
        JMPath connectedComponent = new JMPath();
        connectedComponent.pathType = 3;
        for (int n = 0; n < workPath.size(); ++n) {
            JMPathPoint p = workPath.jmPathPoints.get(n - offset);
            if (!p.isThisSegmentVisible && connectedComponent.size() > 0) {
                resul.add(connectedComponent);
                connectedComponent = new JMPath();
                connectedComponent.pathType = 3;
            }
            connectedComponent.addJMPoint(p);
        }
        resul.add(connectedComponent);
        return new CanonicalJMPath(resul);
    }

    public void separate(int k) {
        JMPathPoint p = this.jmPathPoints.get(k);
        JMPathPoint pnew = p.copy();
        pnew.isThisSegmentVisible = false;
        pnew.type = JMPathPoint.JMPathPointType.INTERPOLATION_POINT;
        this.jmPathPoints.add(k + 1, pnew);
    }

    public int getNumberOfConnectedComponents() {
        return (int)this.jmPathPoints.stream().filter(x -> !x.isThisSegmentVisible).count();
    }

    public void removeConsecutiveHiddenVertices() {
        ArrayList<JMPathPoint> toRemove = new ArrayList<JMPathPoint>();
        for (int n = 0; n < this.jmPathPoints.size(); ++n) {
            JMPathPoint p1 = this.jmPathPoints.get(n);
            JMPathPoint p2 = this.jmPathPoints.get(n + 1);
            if (!(!p1.isThisSegmentVisible & !p2.isThisSegmentVisible)) continue;
            toRemove.add(p1);
        }
        this.jmPathPoints.removeAll(toRemove);
    }

    public JMPath allVisible() {
        JMPath resul = new JMPath();
        for (JMPathPoint p : this.jmPathPoints) {
            JMPathPoint pNew = p.copy();
            pNew.isThisSegmentVisible = true;
            resul.addJMPoint(pNew);
        }
        return resul;
    }

    public void distille() {
        this.removeConsecutiveHiddenVertices();
        double epsilon = 1.0E-6;
        int n = 0;
        while (n < this.size() - 1) {
            JMPathPoint p1 = this.jmPathPoints.get(n);
            JMPathPoint p2 = this.jmPathPoints.get(n + 1);
            if (p1.p.isEquivalentTo(p2.p, epsilon)) {
                p2.cpEnter.copyFrom(p1.cpEnter);
                p2.isThisSegmentVisible = p1.isThisSegmentVisible;
                p2.isCurved = p1.isCurved;
                this.jmPathPoints.remove(p1);
                n = 0;
                continue;
            }
            ++n;
        }
        for (int i = 0; i < this.jmPathPoints.size(); ++i) {
            JMPathPoint p = this.jmPathPoints.get(i);
            JMPathPoint q = this.jmPathPoints.get(i - 1);
            if (p.isCurved) continue;
            p.cpEnter.copyFrom(p.p);
            q.cpExit.copyFrom(q.p);
        }
    }

    public boolean isEquivalentTo(JMPath obj, double epsilon) {
        if (this.size() != obj.size()) {
            return false;
        }
        for (int n = 0; n < this.size(); ++n) {
            JMPathPoint pa2;
            JMPathPoint pa1 = this.jmPathPoints.get(n);
            if (pa1.isEquivalentTo(pa2 = obj.jmPathPoints.get(n), epsilon)) continue;
            return false;
        }
        return true;
    }

    private Vec evaluateBezier(Vec P0, Vec P1, Vec P2, Vec P3, double t) {
        Vec a = P3.add(P2.mult(-3.0)).add(P1.mult(3.0)).add(P0.mult(-1.0));
        Vec b = P2.mult(3.0).add(P1.mult(-6.0)).add(P0.mult(3.0));
        Vec c = P1.mult(3.0).add(P0.mult(-3.0));
        Vec d = P0.copy();
        return d.add(c.mult(t)).add(b.mult(t * t)).add(a.mult(t * t * t));
    }

    private ArrayList<Point> getCriticalPoints(JMPathPoint pOrig, JMPathPoint pDst) {
        double[] solsY;
        Vec v;
        double[] solsX;
        ArrayList<Point> resul = new ArrayList<Point>();
        Vec P0 = pOrig.p.v;
        Vec P1 = pOrig.cpExit.v;
        Vec P2 = pDst.cpEnter.v;
        Vec P3 = pDst.p.v;
        Vec a = P3.add(P2.mult(-3.0)).add(P1.mult(3.0)).add(P0.mult(-1.0)).mult(3.0);
        Vec b = P2.mult(3.0).add(P1.mult(-6.0)).add(P0.mult(3.0)).mult(2.0);
        Vec c = P1.mult(3.0).add(P0.mult(-3.0));
        for (double tCrit : solsX = this.quadraticSolutions(a.x, b.x, c.x)) {
            if (!(tCrit > 0.0) || !(tCrit < 1.0)) continue;
            v = pDst.isCurved ? this.evaluateBezier(P0, P1, P2, P3, tCrit) : pOrig.p.interpolate((Point)pDst.p, (double)tCrit).v;
            resul.add((Point)Point.at(v.x, v.y).drawColor(JMColor.BLUE));
        }
        for (double tCrit : solsY = this.quadraticSolutions(a.y, b.y, c.y)) {
            if (!(tCrit > 0.0) || !(tCrit < 1.0)) continue;
            v = pDst.isCurved ? this.evaluateBezier(P0, P1, P2, P3, tCrit) : pOrig.p.interpolate((Point)pDst.p, (double)tCrit).v;
            resul.add((Point)Point.at(v.x, v.y).drawColor(JMColor.RED));
        }
        return resul;
    }

    private double[] quadraticSolutions(double a, double b, double c) {
        if (a == 0.0) {
            if (c != 0.0) {
                return new double[]{-c / b};
            }
            return new double[0];
        }
        double discriminant = b * b - 4.0 * a * c;
        if (discriminant < 0.0) {
            return new double[0];
        }
        if (discriminant == 0.0) {
            return new double[]{-0.5 * b / a};
        }
        if (discriminant > 0.0) {
            double rdisc = Math.sqrt(discriminant);
            return new double[]{-0.5 * (b + rdisc) / a, -0.5 * (b - rdisc) / a};
        }
        return new double[0];
    }

    public List<Point> getBorderPoints(Anchor.Type type) {
        Stream stream = this.getCriticalPoints().stream();
        Rect bb = this.getBoundingBox();
        List li = null;
        switch (type) {
            case UPPER: {
                li = stream.filter(p -> p.v.y == bb.ymax).collect(Collectors.toList());
                break;
            }
            case LOWER: {
                li = stream.filter(p -> p.v.y == bb.ymin).collect(Collectors.toList());
                break;
            }
            case RIGHT: {
                li = stream.filter(p -> p.v.x == bb.xmax).collect(Collectors.toList());
                break;
            }
            case LEFT: {
                li = stream.filter(p -> p.v.x == bb.xmin).collect(Collectors.toList());
            }
        }
        return li;
    }

    public JMPathPoint get(int index) {
        return this.jmPathPoints.get(index);
    }

    @Override
    public Iterator<JMPathPoint> iterator() {
        return this.jmPathPoints.iterator();
    }

    public JMPath getSubPath(double a, double b) {
        if (a > b) {
            JMPath tempPath = this.copy();
            tempPath.reverse();
            return tempPath.getSubPath(b, a);
        }
        JMPath tempPath = this.copy();
        tempPath.openPath();
        if (a == 1.0 && b == 1.0) {
            JMPath res = JMPath.make(new JMPathPoint[0]);
            res.addPoint(this.get((int)0).p.copy(), this.get((int)0).p.copy());
            return res;
        }
        int size = tempPath.size();
        JMPathPoint beginning = tempPath.get(0);
        JMPathPoint ending = tempPath.get(-1);
        int k1 = (int)Math.floor(a * (double)(size - 1));
        double alpha1 = a * (double)(size - 1) - (double)k1;
        int k2 = (int)Math.floor(b * (double)(size - 1));
        double alpha2 = b * (double)(size - 1) - (double)k2;
        if (a > 0.0) {
            beginning = tempPath.insertJMPointAt(k1, alpha1);
            beginning.isThisSegmentVisible = false;
            if (k1 == k2) {
                alpha2 = (alpha2 - alpha1) / (1.0 - alpha1);
            }
            ++k2;
        }
        if (b < 1.0) {
            ending = tempPath.insertJMPointAt(k2, alpha2);
        }
        int nBegin = tempPath.jmPathPoints.indexOf(beginning);
        int nEnd = tempPath.jmPathPoints.indexOf(ending);
        JMPath subPath = new JMPath();
        subPath.jmPathPoints.addAll(tempPath.jmPathPoints.subList(nBegin, nEnd + 1));
        return subPath;
    }

    public void openPath() {
        JMPathPoint firstP = this.jmPathPoints.get(0);
        if (firstP.isThisSegmentVisible) {
            this.addJMPoint(firstP.copy());
            firstP.isThisSegmentVisible = false;
        }
    }

    public JMPathPoint insertJMPointAt(int k, double alpha) {
        JMPathPoint v1 = this.jmPathPoints.get(k);
        JMPathPoint v2 = this.jmPathPoints.get(k + 1);
        JMPathPoint newPoint = JMPath.getJMPointBetween(v1, v2, alpha);
        this.jmPathPoints.add(k + 1, newPoint);
        newPoint.isThisSegmentVisible = v2.isThisSegmentVisible;
        Point E = v1.p.interpolate(v1.cpExit, alpha);
        Point G = v2.cpEnter.interpolate(v2.p, alpha);
        v1.cpExit.copyFrom(E);
        v2.cpEnter.copyFrom(G);
        return newPoint;
    }

    public JMPath merge(JMPath secondPath, boolean connectAtoB, boolean connectBtoA) {
        JMPath pa = secondPath.copy();
        if (this.isEmpty()) {
            this.jmPathPoints.addAll(pa.jmPathPoints);
            return this;
        }
        JMPathPoint jmPoint = this.jmPathPoints.get(0);
        if (jmPoint.isThisSegmentVisible) {
            this.jmPathPoints.add(jmPoint.copy());
            jmPoint.isThisSegmentVisible = false;
        }
        JMPathPoint jmPoint2 = pa.jmPathPoints.get(0);
        if (jmPoint2.isThisSegmentVisible) {
            pa.jmPathPoints.add(jmPoint2.copy());
        }
        jmPoint2.isThisSegmentVisible = connectAtoB;
        if (connectAtoB) {
            jmPoint2.isCurved = false;
        }
        this.get((int)0).isThisSegmentVisible = connectBtoA;
        if (connectBtoA) {
            this.get((int)0).isCurved = false;
        }
        this.jmPathPoints.addAll(pa.jmPathPoints);
        return this;
    }
}

