/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Stateable;
import com.jmathanim.mathobjects.updateableObjects.Updateable;
import java.text.DecimalFormat;

public class JMPathPoint
extends MathObject
implements Updateable,
Stateable {
    public final Point p;
    public final Point cpExit;
    public final Point cpEnter;
    public Vec cpExitvBackup;
    public Vec cpEntervBackup;
    public boolean isThisSegmentVisible;
    public boolean isCurved;
    public JMPathPointType type;
    public int numDivisions = 0;
    private JMPathPoint pState;

    public static JMPathPoint lineTo(double x, double y) {
        return JMPathPoint.lineTo(new Point(x, y));
    }

    public static JMPathPoint lineTo(Point p) {
        JMPathPoint jmp = new JMPathPoint(p, true, JMPathPointType.VERTEX);
        jmp.isCurved = false;
        return jmp;
    }

    public static JMPathPoint curveTo(Point p) {
        JMPathPoint jmp = new JMPathPoint(p, true, JMPathPointType.VERTEX);
        jmp.isCurved = true;
        return jmp;
    }

    public JMPathPoint(Point p, boolean isVisible, JMPathPointType type) {
        this.p = p;
        this.cpExit = p.copy();
        this.cpEnter = p.copy();
        this.isCurved = false;
        this.isThisSegmentVisible = isVisible;
        this.type = type;
    }

    public JMPathPoint copy() {
        Point pCopy = this.p.copy();
        JMPathPoint resul = new JMPathPoint(pCopy, this.isThisSegmentVisible, this.type);
        resul.cpExit.v.copyFrom(this.cpExit.v);
        resul.cpEnter.v.copyFrom(this.cpEnter.v);
        try {
            resul.cpExitvBackup = this.cpExitvBackup.copy();
            resul.cpEntervBackup = this.cpEntervBackup.copy();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        resul.isCurved = this.isCurved;
        resul.isThisSegmentVisible = this.isThisSegmentVisible;
        return resul;
    }

    void setControlPoint1(Point cp) {
        this.cpExit.v.x = cp.v.x;
        this.cpExit.v.y = cp.v.y;
    }

    void setControlPoint2(Point cp) {
        this.cpEnter.v.x = cp.v.x;
        this.cpEnter.v.y = cp.v.y;
    }

    public String toString() {
        String pattern = "##0.##";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        String labelStr = !"".equals(this.objectLabel) ? "[" + this.objectLabel + "]" : this.objectLabel;
        String resul = labelStr + "(" + decimalFormat.format(this.p.v.x) + ", " + decimalFormat.format(this.p.v.y) + ")";
        if (this.type == JMPathPointType.INTERPOLATION_POINT) {
            resul = "I" + resul;
        }
        if (this.type == JMPathPointType.VERTEX) {
            resul = "V" + resul;
        }
        if (!this.isThisSegmentVisible) {
            resul = resul + "*";
        }
        if (!this.isCurved) {
            resul = resul + "-";
        }
        return resul;
    }

    @Override
    public void update(JMathAnimScene scene) {
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(Math.max(this.p.getUpdateLevel(), this.cpExit.getUpdateLevel()), this.cpEnter.getUpdateLevel());
    }

    @Override
    public void saveState() {
        this.pState = new JMPathPoint(this.p, this.isThisSegmentVisible, this.type);
        this.p.saveState();
        this.cpExit.saveState();
        this.cpEnter.saveState();
        try {
            this.pState.cpExitvBackup.saveState();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.pState.cpEntervBackup.saveState();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.pState.isThisSegmentVisible = this.isThisSegmentVisible;
        this.pState.isCurved = this.isCurved;
        this.pState.type = this.type;
    }

    @Override
    public void restoreState() {
        this.p.restoreState();
        this.cpExit.restoreState();
        this.cpEnter.restoreState();
        if (this.pState != null) {
            try {
                this.pState.cpExitvBackup.restoreState();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                this.pState.cpEntervBackup.restoreState();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.isThisSegmentVisible = this.pState.isThisSegmentVisible;
            this.isCurved = this.pState.isCurved;
            this.type = this.pState.type;
        }
    }

    @Override
    public Point getCenter() {
        return this.p;
    }

    @Override
    public Rect getBoundingBox() {
        return this.p.getBoundingBox();
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
    }

    public void copyFrom(JMPathPoint jmPoint) {
        this.p.copyFrom(jmPoint.p);
        this.cpExit.copyFrom(jmPoint.cpExit);
        this.cpEnter.copyFrom(jmPoint.cpEnter);
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof JMPathPoint)) {
            return;
        }
        JMPathPoint jmp2 = (JMPathPoint)obj;
        this.p.copyStateFrom(jmp2.p);
        this.cpExit.copyStateFrom(jmp2.cpExit);
        this.cpEnter.copyStateFrom(jmp2.cpEnter);
    }

    public boolean isEquivalentTo(JMPathPoint p2, double epsilon) {
        if (p2.isThisSegmentVisible != this.isThisSegmentVisible) {
            return false;
        }
        if (!this.p.isEquivalentTo(p2.p, epsilon)) {
            return false;
        }
        if (!this.cpExit.isEquivalentTo(p2.cpExit, epsilon)) {
            return false;
        }
        return this.cpEnter.isEquivalentTo(p2.cpEnter, epsilon);
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        JMPathPoint pSrc = this.copy();
        Point pDst = (Point)tr.getTransformedObject(pSrc.p);
        Point cp1Dst = (Point)tr.getTransformedObject(pSrc.cpExit);
        Point cp2Dst = (Point)tr.getTransformedObject(pSrc.cpEnter);
        this.p.v.copyFrom(pDst.v);
        this.cpExit.v.copyFrom(cp1Dst.v);
        this.cpEnter.v.copyFrom(cp2Dst.v);
        tr.applyTransformsToDrawingProperties(this);
        return (T)this;
    }

    @Override
    public <T extends MathObject> T rotate(Point center, double angle) {
        this.p.rotate(center, angle);
        this.cpEnter.rotate(center, angle);
        this.cpExit.rotate(center, angle);
        return (T)this;
    }

    @Override
    public <T extends MathObject> T shift(Vec shiftVector) {
        this.p.shift(shiftVector);
        this.cpEnter.shift(shiftVector);
        this.cpExit.shift(shiftVector);
        return (T)this;
    }

    public JMPathPoint interpolate(JMPathPoint q, double alpha) {
        JMPathPoint interpolate;
        if (q.isCurved) {
            Point E = this.p.interpolate(this.cpExit, alpha);
            Point G = q.cpEnter.interpolate(q.p, alpha);
            Point F = this.cpExit.interpolate(q.cpEnter, alpha);
            Point H = E.interpolate(F, alpha);
            Point J = F.interpolate(G, alpha);
            Point K = H.interpolate(J, alpha);
            interpolate = new JMPathPoint(K, q.isThisSegmentVisible, JMPathPointType.INTERPOLATION_POINT);
            interpolate.cpExit.v.copyFrom(J.v);
            interpolate.cpEnter.v.copyFrom(H.v);
        } else {
            Point interP = new Point(this.p.v.interpolate(q.p.v, alpha));
            interpolate = new JMPathPoint(interP, q.isThisSegmentVisible, JMPathPointType.INTERPOLATION_POINT);
        }
        interpolate.isCurved = q.isCurved;
        return interpolate;
    }

    public static enum JMPathPointType {
        NONE,
        VERTEX,
        INTERPOLATION_POINT,
        CONTROL_POINT;

    }
}

