/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Constructible.Lines.HasDirection;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class Line
extends Shape
implements HasDirection {
    private final JMPathPoint bp1;
    private final JMPathPoint bp2;
    MODrawPropertiesArray mpArray = new MODrawPropertiesArray();
    private Point p1;
    private Point p2;
    private final Shape visiblePiece;

    public static Line XAxis() {
        return new Line(new Point(0.0, 0.0), new Point(1.0, 0.0));
    }

    public static Line XYBisector() {
        return new Line(new Point(0.0, 0.0), new Point(1.0, 1.0));
    }

    public static Line YAxis() {
        return new Line(new Point(0.0, 0.0), new Point(0.0, 1.0));
    }

    public static Line make(Point a, Point b) {
        return new Line(a, b);
    }

    public static Line make(Point a, Vec b) {
        return new Line(a, a.add(b));
    }

    public Line(Point p, Vec v) {
        this(p, p.add(v));
    }

    public Line(Point p1, Point p2) {
        this(p1, p2, null);
    }

    public Line(Point p1, Point p2, MODrawProperties mp) {
        super(mp);
        this.mpArray.copyFrom(JMathAnimConfig.getConfig().getDefaultMP());
        this.mpArray.copyFrom(mp);
        this.p1 = p1;
        this.p2 = p2;
        this.getPath().clear();
        this.bp1 = new JMPathPoint(new Point(0.0, 0.0), true, JMPathPoint.JMPathPointType.VERTEX);
        this.bp2 = new JMPathPoint(new Point(0.0, 0.0), true, JMPathPoint.JMPathPointType.VERTEX);
        this.visiblePiece = new Shape();
        this.visiblePiece.getPath().addJMPoint(this.bp1, this.bp2);
        this.visiblePiece.getMp().copyFrom(this.getMp());
        this.getPath().addPoint(p1, p2);
        this.get((int)0).isThisSegmentVisible = false;
        this.mpArray.add(this.visiblePiece);
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        this.getP1().applyAffineTransform(tr);
        this.getP2().applyAffineTransform(tr);
        tr.applyTransformsToDrawingProperties(this);
        return (T)this;
    }

    public final void computeBoundPoints(Camera cam) {
        Rect rect = cam.getMathView();
        double[] intersectLine = rect.intersectLine(this.p1.v.x, this.p1.v.y, this.p2.v.x, this.p2.v.y);
        if (intersectLine == null) {
            this.bp1.p.v.x = this.p1.v.x;
            this.bp1.p.v.y = this.p1.v.y;
            this.bp2.p.v.x = this.p2.v.x;
            this.bp2.p.v.y = this.p2.v.y;
        } else {
            this.bp1.p.v.x = intersectLine[0];
            this.bp1.p.v.y = intersectLine[1];
            this.bp2.p.v.x = intersectLine[2];
            this.bp2.p.v.y = intersectLine[3];
        }
        this.bp1.cpExit.v.x = this.bp1.p.v.x;
        this.bp1.cpExit.v.y = this.bp1.p.v.y;
        this.bp1.cpEnter.v.x = this.bp1.p.v.x;
        this.bp1.cpEnter.v.y = this.bp1.p.v.y;
        this.bp2.cpExit.v.x = this.bp2.p.v.x;
        this.bp2.cpExit.v.y = this.bp2.p.v.y;
        this.bp2.cpEnter.v.x = this.bp2.p.v.x;
        this.bp2.cpEnter.v.y = this.bp2.p.v.y;
    }

    @Override
    public Line copy() {
        Line resul = new Line(this.p1.copy(), this.p2.copy());
        resul.getMp().copyFrom(this.getMp());
        return resul;
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        this.update(JMathAnimConfig.getConfig().getScene());
        if (this.isVisible()) {
            this.visiblePiece.draw(scene, r);
        }
        scene.markAsAlreadyDrawed(this);
    }

    public Point getBorderPoint1(JMathAnimScene scene) {
        this.update(scene);
        return this.bp1.p.copy();
    }

    public Point getBorderPoint2(JMathAnimScene scene) {
        this.update(scene);
        return this.bp2.p.copy();
    }

    @Override
    public Point getCenter() {
        return this.p1.copy();
    }

    @Override
    public Vec getDirection() {
        return this.p1.to(this.p2);
    }

    @Override
    public Stylable getMp() {
        return this.mpArray;
    }

    public Point getP1() {
        return this.p1;
    }

    public Point getP2() {
        return this.p2;
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(this.p1.getUpdateLevel(), this.p2.getUpdateLevel()) + 1;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.p1.restoreState();
        this.p2.restoreState();
    }

    @Override
    public void saveState() {
        super.saveState();
        this.p1.saveState();
        this.p2.saveState();
    }

    public Shape toSegment(Camera cam, double scale) {
        this.computeBoundPoints(cam);
        Point a = (Point)this.bp1.p.copy().scale(this.getCenter(), scale, scale);
        Point b = (Point)this.bp2.p.copy().scale(this.getCenter(), scale, scale);
        Shape segment = Shape.segment(a, b);
        segment.getMp().copyFrom(this.getMp());
        return segment;
    }

    public Shape toSegment(Camera cam) {
        return this.toSegment(cam, 1.0);
    }

    @Override
    public void update(JMathAnimScene scene) {
        super.update(scene);
        this.computeBoundPoints(scene.getCamera());
    }
}

