/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Boxable;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Drawable;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Stateable;
import com.jmathanim.mathobjects.updateableObjects.Updateable;
import javafx.scene.shape.StrokeLineCap;

public abstract class MathObject
implements Drawable,
Updateable,
Stateable,
Boxable {
    protected JMathAnimScene scene;
    private String debugText = "";
    private MODrawProperties mp;
    public String objectLabel = "";
    public boolean absoluteSize = false;
    public Point absoluteAnchorPoint;
    private Anchor.Type absoluteAnchorType = Anchor.Type.CENTER;

    public MathObject() {
        this(null);
    }

    public MathObject(MODrawProperties prop) {
        this.scene = JMathAnimConfig.getConfig().getScene();
        this.mp = JMathAnimConfig.getConfig().getDefaultMP();
        this.mp.copyFrom(prop);
    }

    public Point getCenter() {
        return this.getBoundingBox().getCenter();
    }

    public <T extends MathObject> T shift(Vec shiftVector) {
        AffineJTransform tr = AffineJTransform.createTranslationTransform(shiftVector);
        tr.applyTransform(this);
        return (T)this;
    }

    public final <T extends MathObject> T shift(double x, double y) {
        return this.shift(new Vec(x, y));
    }

    public final <T extends MathObject> T shift(double x, double y, double z) {
        return this.shift(new Vec(x, y, z));
    }

    public <T extends MathObject> T scale(double sx, double sy) {
        this.scale(this.getCenter(), sx, sy);
        return (T)this;
    }

    public <T extends MathObject> T scale(double s) {
        return this.scale(this.getCenter(), s, s);
    }

    public final <T extends MathObject> T scale(Point p, double sx, double sy) {
        return this.scale(p, sx, sy, 1.0);
    }

    public final <T extends MathObject> T scale(double sx, double sy, double sz) {
        this.scale(this.getBoundingBox().getCenter(), sx, sy, sz);
        return (T)this;
    }

    public <T extends MathObject> T scale(Point scaleCenter, double sx, double sy, double sz) {
        AffineJTransform tr = AffineJTransform.createScaleTransform(scaleCenter, sx, sy, sz);
        tr.applyTransform(this);
        return (T)this;
    }

    public <T extends MathObject> T setHeight(double h) {
        this.scale(h / this.getBoundingBox().getHeight());
        return (T)this;
    }

    public <T extends MathObject> T setWidth(double w) {
        this.scale(w / this.getBoundingBox().getWidth());
        return (T)this;
    }

    public final <T extends MathObject> T center() {
        this.stackToScreen(Anchor.Type.CENTER);
        return (T)this;
    }

    public final <T extends MathObject> T vCenter() {
        Vec v = this.getCenter().v;
        this.center();
        this.shift(v.x - this.getCenter().v.x, 0.0);
        return (T)this;
    }

    public final <T extends MathObject> T hCenter() {
        Vec v = this.getCenter().v;
        this.center();
        this.shift(0.0, v.y - this.getCenter().v.y);
        return (T)this;
    }

    public <T extends MathObject> T rotate(double angle) {
        return this.rotate(this.getCenter(), angle);
    }

    public <T extends MathObject> T rotate(Point center, double angle) {
        AffineJTransform tr = AffineJTransform.create2DRotationTransform(center, angle);
        tr.applyTransform(this);
        return (T)this;
    }

    public <T extends MathObject> T rotate3d(double anglex, double angley, double anglez) {
        return this.rotate3d(this.getCenter(), anglex, angley, anglez);
    }

    public <T extends MathObject> T rotate3d(Point center, double anglex, double angley, double anglez) {
        AffineJTransform tr = AffineJTransform.create3DRotationTransform(center, anglex, angley, anglez);
        tr.applyTransform(this);
        return (T)this;
    }

    public abstract <T extends MathObject> T copy();

    public abstract void copyStateFrom(MathObject var1);

    @Override
    public abstract Rect getBoundingBox();

    public void setAlpha(double t) {
        this.drawAlpha(t);
        this.fillAlpha(t);
    }

    @Override
    public void saveState() {
        this.getMp().saveState();
    }

    @Override
    public void restoreState() {
        this.getMp().restoreState();
    }

    public Stylable getMp() {
        return this.mp;
    }

    public <T extends MathObject> T setMp(MODrawProperties newMp) {
        this.getMp().copyFrom(newMp);
        return (T)this;
    }

    public <T extends MathObject> T color(PaintStyle dc) {
        this.drawColor(dc);
        this.fillColor(dc);
        return (T)this;
    }

    public <T extends MathObject> T color(String str) {
        this.drawColor(str);
        this.fillColor(str);
        return (T)this;
    }

    public <T extends MathObject> T drawColor(PaintStyle dc) {
        this.getMp().setDrawColor(dc);
        return (T)this;
    }

    public final <T extends MathObject> T drawColor(String str) {
        this.drawColor(JMColor.parse(str));
        return (T)this;
    }

    public <T extends MathObject> T fillColor(PaintStyle fc) {
        this.getMp().setFillColor(fc);
        return (T)this;
    }

    public final <T extends MathObject> T fillColor(String str) {
        this.fillColor(JMColor.parse(str));
        return (T)this;
    }

    public <T extends MathObject> T drawAlpha(double alpha) {
        this.getMp().setDrawAlpha(alpha);
        return (T)this;
    }

    public <T extends MathObject> T fillAlpha(double alpha) {
        this.getMp().setFillAlpha(alpha);
        return (T)this;
    }

    public <T extends MathObject> T multFillAlpha(double alphaScale) {
        this.getMp().setMultFillAlpha(alphaScale);
        return (T)this;
    }

    public <T extends MathObject> T multDrawAlpha(double alphaScale) {
        this.getMp().setMultDrawAlpha(alphaScale);
        return (T)this;
    }

    public <T extends MathObject> T thickness(double newThickness) {
        this.getMp().setThickness(newThickness);
        return (T)this;
    }

    public <T extends MathObject> T dashStyle(MODrawProperties.DashStyle dashStyle) {
        this.getMp().setDashStyle(dashStyle);
        return (T)this;
    }

    public <T extends MathObject> T visible(boolean visible) {
        this.getMp().setVisible(visible);
        return (T)this;
    }

    public Point getAbsoluteAnchor() {
        return Anchor.getAnchorPoint(this, this.absoluteAnchorType);
    }

    public Point getAbsoluteAnchorPoint() {
        return this.absoluteAnchorPoint;
    }

    public <T extends MathObject> T setAbsoluteSize(Point p) {
        this.absoluteAnchorPoint = p;
        this.absoluteAnchorType = Anchor.Type.BY_POINT;
        this.absoluteSize = true;
        return (T)this;
    }

    public final <T extends MathObject> T stackTo(Boxable obj, Anchor.Type anchorType) {
        return this.stackTo(obj, anchorType, 0.0);
    }

    public <T extends MathObject> T stackTo(Anchor.Type originAnchor, Boxable destinyObject, Anchor.Type destinyAnchor, double originGap) {
        return this.stackTo(originAnchor, destinyObject, destinyAnchor, originGap, 0.0);
    }

    public <T extends MathObject> T stackTo(Anchor.Type originAnchor, Boxable destinyObject, Anchor.Type destinyAnchor, double originGap, double destinyGap) {
        if (!destinyObject.isEmpty()) {
            Point B = Anchor.getAnchorPoint(destinyObject, destinyAnchor, destinyGap);
            Point A = Anchor.getAnchorPoint(this, originAnchor, originGap);
            this.shift(A.to(B));
        }
        return (T)this;
    }

    public <T extends MathObject> T stackToRW(Anchor.Type anchorObj, Boxable dstObj, Anchor.Type anchorType, double gap) {
        return this.stackTo(anchorObj, dstObj, anchorType, gap * this.getWidth());
    }

    public <T extends MathObject> T stackToRH(Anchor.Type anchorObj, Boxable dstObj, Anchor.Type anchorType, double gap) {
        return this.stackTo(anchorObj, dstObj, anchorType, gap * this.getHeight());
    }

    public <T extends MathObject> T stackToRH(Boxable dstObj, Anchor.Type anchorType, double gap) {
        return this.stackToRH(Anchor.reverseAnchorPoint(anchorType), dstObj, anchorType, gap);
    }

    public <T extends MathObject> T stackToRW(Boxable dstObj, Anchor.Type anchorType, double gap) {
        return this.stackToRW(Anchor.reverseAnchorPoint(anchorType), dstObj, anchorType, gap);
    }

    public <T extends MathObject> T stackTo(Boxable obj, Anchor.Type anchorType, double gap) {
        return this.stackTo(Anchor.reverseAnchorPoint(anchorType), obj, anchorType, gap);
    }

    public final <T extends MathObject> T stackToScreen(Anchor.Type anchorType) {
        return this.stackToScreen(anchorType, 0.0, 0.0);
    }

    public <T extends MathObject> T stackToScreen(Anchor.Type anchorType, double xMargin, double yMargin) {
        Point B = Anchor.getScreenAnchorPoint(anchorType, xMargin, yMargin);
        Point A = Anchor.getAnchorPoint(this, anchorType);
        return this.shift(A.to(B));
    }

    public final <T extends MathObject> T moveTo(Point p) {
        return this.stackTo(p, Anchor.Type.CENTER);
    }

    public <T extends MathObject> T moveTo(double x, double y) {
        return this.moveTo(Point.at(x, y));
    }

    public <T extends MathObject> T setAbsoluteSize() {
        return this.setAbsoluteSize(Anchor.Type.CENTER);
    }

    public <T extends MathObject> T setAbsoluteSize(Anchor.Type anchorType) {
        this.absoluteSize = true;
        this.absoluteAnchorType = anchorType;
        this.absoluteSize = true;
        return (T)this;
    }

    public <T extends MathObject> T setRelativeSize() {
        this.absoluteSize = false;
        return (T)this;
    }

    public <T extends MathObject> T layer(int layer) {
        this.getMp().setLayer(layer);
        return (T)this;
    }

    public Integer getLayer() {
        return this.getMp().getLayer();
    }

    public <T extends MathObject> T style(String name) {
        this.getMp().loadFromStyle(name);
        return (T)this;
    }

    public <T extends MathObject> T linecap(StrokeLineCap strokeLineCap) {
        this.getMp().setLinecap(strokeLineCap);
        return (T)this;
    }

    @Override
    public void update(JMathAnimScene scene) {
    }

    @Override
    public int getUpdateLevel() {
        return 0;
    }

    public String getDebugText() {
        return this.debugText;
    }

    public <T extends MathObject> T debugText(String debugText) {
        this.debugText = debugText;
        return (T)this;
    }

    public boolean isVisible() {
        return this.getMp().isVisible();
    }

    public double getWidth() {
        Rect b = this.getBoundingBox();
        if (b == null) {
            return 0.0;
        }
        return b.getWidth();
    }

    public double getHeight() {
        Rect b = this.getBoundingBox();
        if (b == null) {
            return 0.0;
        }
        return b.getHeight();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public <T extends MathObject> T align(Boxable obj, Align type) {
        Vec shiftVector = Vec.to(0.0, 0.0);
        Rect thisBoundingBox = this.getBoundingBox();
        Rect objectBoundingBox = obj.getBoundingBox();
        switch (type) {
            case LOWER: {
                shiftVector.y = objectBoundingBox.ymin - thisBoundingBox.ymin;
                break;
            }
            case UPPER: {
                shiftVector.y = objectBoundingBox.ymax - thisBoundingBox.ymax;
                break;
            }
            case LEFT: {
                shiftVector.x = objectBoundingBox.xmin - thisBoundingBox.xmin;
                break;
            }
            case RIGHT: {
                shiftVector.x = objectBoundingBox.xmax - thisBoundingBox.xmax;
                break;
            }
            case VCENTER: {
                shiftVector.y = 0.5 * (objectBoundingBox.ymin + objectBoundingBox.ymax - (thisBoundingBox.ymin + thisBoundingBox.ymax));
                break;
            }
            case HCENTER: {
                shiftVector.x = 0.5 * (objectBoundingBox.xmin + objectBoundingBox.xmax - (thisBoundingBox.xmin + thisBoundingBox.xmax));
            }
        }
        this.shift(shiftVector);
        return (T)this;
    }

    public <T extends MathObject> T applyAffineTransform(AffineJTransform transform) {
        return (T)this;
    }

    public void addToSceneHook(JMathAnimScene scene) {
    }

    public static enum Align {
        LEFT,
        RIGHT,
        UPPER,
        LOWER,
        HCENTER,
        VCENTER;

    }
}

