/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.EmptyRect;
import com.jmathanim.Utils.Layouts.GroupLayout;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class MathObjectGroup
extends MathObject
implements Iterable<MathObject> {
    MODrawPropertiesArray mpArray = new MODrawPropertiesArray();
    private final ArrayList<MathObject> objects;

    public static MathObjectGroup make(MathObject ... objects) {
        return new MathObjectGroup(objects);
    }

    public MathObjectGroup divide(int size) {
        MathObjectGroup dividedGroup = MathObjectGroup.make(new MathObject[0]);
        MathObjectGroup auxGroup = null;
        for (int n = 0; n < this.size(); ++n) {
            if (n % size == 0) {
                auxGroup = MathObjectGroup.make(new MathObject[0]);
                dividedGroup.add((MathObject)auxGroup);
            }
            auxGroup.add(this.get(n));
        }
        return dividedGroup;
    }

    public MathObjectGroup flatten() {
        return this.flatten(this);
    }

    private MathObjectGroup flatten(MathObjectGroup group) {
        MathObjectGroup resul = MathObjectGroup.make(new MathObject[0]);
        for (MathObject obj : group) {
            if (obj instanceof MathObjectGroup) {
                MathObjectGroup cc = this.flatten((MathObjectGroup)obj);
                resul.addAll(cc.getObjects());
                continue;
            }
            resul.add(obj);
        }
        return resul;
    }

    public MathObjectGroup() {
        this.objects = new ArrayList();
    }

    public MathObjectGroup(MathObject ... objects) {
        this(new ArrayList<MathObject>(Arrays.asList(objects)));
    }

    public MathObjectGroup(ArrayList<MathObject> objects) {
        this.objects = objects;
        for (MathObject o : objects) {
            this.mpArray.add(o);
        }
    }

    public MathObjectGroup add(MathObject ... objs) {
        for (MathObject obj : objs) {
            this.add(obj);
        }
        return this;
    }

    public MathObjectGroup add(MathObject e) {
        if (e != null) {
            this.objects.add(e);
            this.mpArray.add(e);
        }
        return this;
    }

    public void add(int index, MathObject element) {
        this.objects.add(index, element);
        this.mpArray.add(element);
    }

    public void addAll(Collection<? extends MathObject> c) {
        this.objects.addAll(c);
        this.mpArray.getObjects().addAll(c);
    }

    public void addAll(int index, Collection<? extends MathObject> c) {
        this.objects.addAll(index, c);
        this.mpArray.getObjects().addAll(c);
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        for (MathObject obj : this.objects) {
            obj.applyAffineTransform(tr);
        }
        tr.applyTransformsToDrawingProperties(this);
        return (T)this;
    }

    public void clear() {
        this.objects.clear();
        this.mpArray.getObjects().clear();
    }

    public MathObjectGroup copy() {
        MathObjectGroup copy = new MathObjectGroup();
        copy.getMp().copyFrom(this.getMp());
        for (MathObject obj : this.getObjects()) {
            copy.add((MathObject)obj.copy());
        }
        return copy;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof MathObjectGroup)) {
            return;
        }
        MathObjectGroup mg = (MathObjectGroup)obj;
        this.getMp().copyFrom(mg.getMp());
        int n = 0;
        for (MathObject o : this.getObjects()) {
            o.copyStateFrom(mg.get(n));
            ++n;
        }
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible()) {
            for (MathObject obj : this.getObjects()) {
                if (scene.isAlreadyDrawed(obj)) continue;
                obj.draw(scene, r);
            }
        }
        scene.markAsAlreadyDrawed(this);
    }

    public MathObject get(int index) {
        return this.objects.get(index);
    }

    @Override
    public Rect getBoundingBox() {
        if (this.objects.isEmpty()) {
            return new EmptyRect();
        }
        Rect bbox = this.objects.get(0).getBoundingBox();
        for (MathObject obj : this.objects) {
            bbox = Rect.union(bbox, obj.getBoundingBox());
        }
        return bbox;
    }

    public ArrayList<MathObject> getObjects() {
        return this.objects;
    }

    public int indexOf(Object o) {
        return this.objects.indexOf(o);
    }

    @Override
    public Iterator<MathObject> iterator() {
        return this.objects.iterator();
    }

    @Override
    public void restoreState() {
        this.mpArray.restoreState();
        for (MathObject obj : this.objects) {
            obj.restoreState();
        }
    }

    @Override
    public void saveState() {
        this.mpArray.saveState();
        for (MathObject obj : this.objects) {
            obj.saveState();
        }
    }

    @Override
    public <T extends MathObject> T setAbsoluteSize(Anchor.Type anchorType) {
        for (MathObject obj : this.objects) {
            obj.setAbsoluteSize(anchorType);
        }
        return (T)this;
    }

    @Override
    public <T extends MathObject> T setAbsoluteSize() {
        return super.setAbsoluteSize();
    }

    public <T extends MathObjectGroup> T setLayout(GroupLayout layout) {
        layout.applyLayout(this);
        return (T)this;
    }

    public <T extends MathObjectGroup> T setLayout(Layout layout, double gap) {
        return this.setLayout(null, layout, gap);
    }

    public <T extends MathObjectGroup> T setLayout(MathObject corner, Layout layout, double gap) {
        Anchor.Type anchor1 = Anchor.Type.CENTER;
        Anchor.Type anchor2 = Anchor.Type.CENTER;
        double hgap = 0.0;
        double vgap = 0.0;
        switch (layout) {
            case CENTER: {
                anchor1 = Anchor.Type.CENTER;
                anchor2 = Anchor.Type.CENTER;
                break;
            }
            case RIGHT: {
                anchor1 = Anchor.Type.LEFT;
                anchor2 = Anchor.Type.RIGHT;
                hgap = gap;
                break;
            }
            case LEFT: {
                anchor1 = Anchor.Type.RIGHT;
                anchor2 = Anchor.Type.LEFT;
                hgap = gap;
                break;
            }
            case UPPER: {
                anchor1 = Anchor.Type.LOWER;
                anchor2 = Anchor.Type.UPPER;
                vgap = gap;
                break;
            }
            case LOWER: {
                anchor1 = Anchor.Type.UPPER;
                anchor2 = Anchor.Type.LOWER;
                vgap = gap;
                break;
            }
            case URIGHT: {
                anchor1 = Anchor.Type.UL;
                anchor2 = Anchor.Type.UR;
                hgap = gap;
                break;
            }
            case ULEFT: {
                anchor1 = Anchor.Type.UR;
                anchor2 = Anchor.Type.UL;
                hgap = gap;
                break;
            }
            case DRIGHT: {
                anchor1 = Anchor.Type.DL;
                anchor2 = Anchor.Type.DR;
                hgap = gap;
                break;
            }
            case DLEFT: {
                anchor1 = Anchor.Type.DR;
                anchor2 = Anchor.Type.DL;
                hgap = gap;
                break;
            }
            case RUPPER: {
                anchor1 = Anchor.Type.DR;
                anchor2 = Anchor.Type.UR;
                vgap = gap;
                break;
            }
            case LUPPER: {
                anchor1 = Anchor.Type.DL;
                anchor2 = Anchor.Type.UL;
                vgap = gap;
                break;
            }
            case RLOWER: {
                anchor1 = Anchor.Type.UR;
                anchor2 = Anchor.Type.DR;
                vgap = gap;
                break;
            }
            case LLOWER: {
                anchor1 = Anchor.Type.UL;
                anchor2 = Anchor.Type.DL;
                vgap = gap;
                break;
            }
            case DIAG1: {
                anchor1 = Anchor.Type.DL;
                anchor2 = Anchor.Type.UR;
                vgap = gap;
                hgap = gap;
                break;
            }
            case DIAG2: {
                anchor1 = Anchor.Type.DR;
                anchor2 = Anchor.Type.UL;
                vgap = gap;
                hgap = gap;
                break;
            }
            case DIAG3: {
                anchor1 = Anchor.Type.UR;
                anchor2 = Anchor.Type.DL;
                vgap = gap;
                hgap = gap;
                break;
            }
            case DIAG4: {
                anchor1 = Anchor.Type.UL;
                anchor2 = Anchor.Type.DR;
                vgap = gap;
                hgap = gap;
                break;
            }
            default: {
                JMathAnimScene.logger.error("Layout not recognized, reverting to CENTER");
            }
        }
        if (corner != null) {
            this.objects.get(0).stackTo(anchor1, corner, anchor2, hgap, vgap);
        }
        for (int n = 1; n < this.objects.size(); ++n) {
            this.objects.get(n).stackTo(anchor1, this.objects.get(n - 1), anchor2, hgap, vgap);
        }
        return (T)this;
    }

    @Override
    public <T extends MathObject> T setRelativeSize() {
        for (MathObject obj : this.objects) {
            obj.setRelativeSize();
        }
        return (T)this;
    }

    public int size() {
        return this.objects.size();
    }

    public MathObject[] toArray() {
        return this.objects.toArray(new MathObject[this.objects.size()]);
    }

    @Override
    public void update(JMathAnimScene scene) {
    }

    @Override
    public <T extends MathObject> T visible(boolean visible) {
        for (MathObject obj : this.objects) {
            obj.visible(visible);
        }
        return (T)this;
    }

    @Override
    public Stylable getMp() {
        return this.mpArray;
    }

    public static enum Layout {
        CENTER,
        RIGHT,
        LEFT,
        UPPER,
        LOWER,
        URIGHT,
        ULEFT,
        DRIGHT,
        DLEFT,
        RUPPER,
        LUPPER,
        RLOWER,
        LLOWER,
        DIAG1,
        DIAG2,
        DIAG3,
        DIAG4;

    }
}

