/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.EmptyRect;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MultiShapeObject
extends MathObject
implements Iterable<Shape> {
    protected MODrawPropertiesArray mpMultiShape;
    public boolean isAddedToScene = false;
    protected final ArrayList<Shape> shapes = new ArrayList();

    public static MultiShapeObject make(Shape ... shapes) {
        return new MultiShapeObject(shapes);
    }

    public MultiShapeObject() {
        this(new ArrayList<Shape>());
    }

    public MultiShapeObject(Shape ... shapes) {
        this(Arrays.asList(shapes));
    }

    public MultiShapeObject(List<Shape> jmps) {
        this.shapes.addAll(jmps);
        this.mpMultiShape = new MODrawPropertiesArray();
        for (MathObject mathObject : this.shapes) {
            this.mpMultiShape.add(mathObject);
        }
    }

    public boolean add(Shape e) {
        this.mpMultiShape.add(e);
        return this.shapes.add(e);
    }

    @Override
    public <T extends MathObject> T fillColor(PaintStyle fc) {
        for (Shape jmp : this.shapes) {
            jmp.fillColor(fc);
        }
        return super.fillColor(fc);
    }

    @Override
    public <T extends MathObject> T drawColor(PaintStyle dc) {
        for (Shape jmp : this.shapes) {
            jmp.drawColor(dc);
        }
        return super.drawColor(dc);
    }

    public MultiShapeObject copy() {
        MultiShapeObject resul = new MultiShapeObject();
        resul.getMp().copyFrom(this.getMp());
        for (Shape sh : this.shapes) {
            Shape copy = sh.copy();
            resul.add(copy);
        }
        resul.absoluteSize = this.absoluteSize;
        return resul;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof MultiShapeObject)) {
            return;
        }
        MultiShapeObject msh = (MultiShapeObject)obj;
        this.getMp().copyFrom(msh.getMp());
        int n = 0;
        for (Shape s : this.shapes) {
            s.copyStateFrom(msh.get(n));
            s.getMp().copyFrom(msh.get(n).getMp());
            ++n;
        }
    }

    @Override
    public <T extends MathObject> T setAbsoluteSize(Anchor.Type anchorType) {
        super.setAbsoluteSize(anchorType);
        Point p = Anchor.getAnchorPoint(this, anchorType);
        for (Shape sh : this.shapes) {
            sh.setAbsoluteSize(p);
        }
        return (T)this;
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible()) {
            int n = 0;
            for (Shape jmp : this.shapes) {
                if (jmp.isVisible() && !scene.isAlreadyDrawed(jmp)) {
                    if (this.absoluteSize) {
                        r.drawAbsoluteCopy(jmp, this.getAbsoluteAnchor().v);
                    } else {
                        jmp.draw(scene, r);
                    }
                }
                ++n;
            }
        }
        scene.markAsAlreadyDrawed(this);
    }

    public <T extends MultiShapeObject> T setShowDebugIndices(boolean value) {
        if (value) {
            int k = 0;
            for (Shape sh : this.shapes) {
                sh.debugText("" + k);
                ++k;
            }
        } else {
            for (Shape sh : this.shapes) {
                sh.debugText("");
            }
        }
        return (T)this;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.shapes.size() > 0) {
            Rect resul = null;
            for (Shape jmp : this.shapes) {
                resul = Rect.union(resul, jmp.getBoundingBox());
            }
            return resul;
        }
        return new EmptyRect();
    }

    public Shape get(int n) {
        return this.shapes.get(n);
    }

    @Override
    public void update(JMathAnimScene scene) {
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.getMp().restoreState();
        for (Shape o : this.shapes) {
            o.restoreState();
        }
    }

    @Override
    public void saveState() {
        super.saveState();
        this.getMp().saveState();
        for (Shape o : this.shapes) {
            o.saveState();
        }
    }

    public ArrayList<Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public Iterator<Shape> iterator() {
        return this.shapes.iterator();
    }

    public int size() {
        return this.shapes.size();
    }

    public <T extends MultiShapeObject> T alignCenter(int index, MultiShapeObject otherObject, int indexOtherObject) {
        this.shift(this.get(index).getCenter().to(otherObject.get(indexOtherObject).getCenter()));
        return (T)this;
    }

    @Override
    public boolean isEmpty() {
        boolean resul = false;
        for (Shape sh : this.shapes) {
            resul |= sh.isEmpty();
        }
        return resul;
    }

    public <T extends MultiShapeObject> T slice(boolean delete, Integer ... indices) {
        int n;
        List<Integer> list = Arrays.asList(indices);
        MultiShapeObject resul = this.copy();
        for (n = 0; n < resul.size(); ++n) {
            resul.shapes.set(n, new Shape());
        }
        for (n = 0; n < this.shapes.size(); ++n) {
            if (!list.contains(n)) continue;
            Shape copy = this.get(n).copy();
            resul.shapes.set(n, copy);
            resul.mpMultiShape.add(copy);
            if (!delete) continue;
            this.mpMultiShape.remove(this.get(n));
            this.shapes.set(n, new Shape());
        }
        return (T)resul;
    }

    public <T extends MultiShapeObject> T slice(Integer ... indices) {
        return this.slice(true, indices);
    }

    public Shape[] getSubArray(int ... indices) {
        Shape[] resul = new Shape[indices.length];
        int k = 0;
        for (int n : indices) {
            resul[k] = this.shapes.get(n);
            ++k;
        }
        return resul;
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        for (Shape sh : this.shapes) {
            sh.applyAffineTransform(tr);
        }
        tr.applyTransformsToDrawingProperties(this);
        return (T)this;
    }

    @Override
    public final Stylable getMp() {
        return this.mpMultiShape;
    }

    public boolean containsPoint(Point p) {
        return this.containsPoint(p.v);
    }

    public boolean containsPoint(Vec v) {
        for (Shape sh : this.shapes) {
            if (!sh.containsPoint(v)) continue;
            return true;
        }
        return false;
    }

    public Shape[] toArray() {
        return this.shapes.toArray(new Shape[this.shapes.size()]);
    }
}

