/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Utils.Vec;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.function.DoubleUnaryOperator;

public class ParametricCurve
extends Shape {
    public static final double DELTA_DERIVATIVE = 1.0E-6;
    public static final int DEFAULT_NUMBER_OF_POINTS = 50;
    private DoubleUnaryOperator functionXBackup;
    private DoubleUnaryOperator functionYBackup;
    public final ArrayList<Double> tPoints;
    public FunctionDefinitionType functionType;
    public DoubleUnaryOperator functionX;
    public DoubleUnaryOperator functionY;
    public DoubleUnaryOperator functionZ;

    public static ParametricCurve make(DoubleUnaryOperator fx, DoubleUnaryOperator fy, double tmin, double tmax) {
        return ParametricCurve.make(fx, fy, x -> 0.0, tmin, tmax, 50);
    }

    public static ParametricCurve make(DoubleUnaryOperator fx, DoubleUnaryOperator fy, DoubleUnaryOperator fz, double tmin, double tmax, int numPoints) {
        ParametricCurve resul = new ParametricCurve(fx, fy, fz, tmin, tmax, numPoints);
        resul.functionType = FunctionDefinitionType.LAMBDA_CARTESIAN;
        resul.generateFunctionPoints();
        return resul;
    }

    public static ParametricCurve makePolar(DoubleUnaryOperator fr, DoubleUnaryOperator ftheta, double tmin, double tmax) {
        return ParametricCurve.makePolar(fr, ftheta, tmin, tmax, 50);
    }

    public static ParametricCurve makePolar(DoubleUnaryOperator fr, DoubleUnaryOperator ftheta, double tmin, double tmax, int numPoints) {
        ParametricCurve resul = new ParametricCurve(fr, ftheta, t -> 0.0, tmin, tmax, numPoints);
        resul.functionType = FunctionDefinitionType.LAMBDA_POLAR;
        resul.generateFunctionPoints();
        return resul;
    }

    private ParametricCurve(DoubleUnaryOperator fx, DoubleUnaryOperator fy, DoubleUnaryOperator fz, double tmin, double tmax, int numPoints) {
        this.functionX = fx;
        this.functionY = fy;
        this.functionZ = fz;
        this.functionType = FunctionDefinitionType.LAMBDA_CARTESIAN;
        this.tPoints = new ArrayList();
        for (int n = 0; n < numPoints; ++n) {
            double t = tmin + (tmax - tmin) * (double)n / (double)(numPoints - 1);
            this.tPoints.add(t);
        }
    }

    private ParametricCurve(DoubleUnaryOperator fx, DoubleUnaryOperator fy, ArrayList<Double> xPoints) {
        this.functionX = fx;
        this.functionY = fy;
        this.tPoints = xPoints;
        this.functionType = FunctionDefinitionType.LAMBDA_CARTESIAN;
    }

    private void generateFunctionPoints() {
        for (int n = 0; n < this.tPoints.size(); ++n) {
            double t = this.tPoints.get(n);
            double[] xyz = this.getFunctionValue(t);
            Point p = Point.at(xyz[0], xyz[1], xyz[2]);
            JMPathPoint jmp = JMPathPoint.curveTo(p);
            this.getPath().addJMPoint(jmp);
        }
        this.get((int)0).isThisSegmentVisible = this.getPoint(0).isEquivalentTo(this.getPoint(-1), 1.0E-7);
        this.generateControlPoints();
    }

    private void generateControlPoints() {
        for (int n = 0; n < this.tPoints.size(); ++n) {
            Vec v;
            double delta;
            JMPathPoint jmp = this.get(n);
            double t = this.tPoints.get(n);
            if (n < this.tPoints.size() - 1) {
                delta = 0.3 * (this.tPoints.get(n + 1) - t);
                v = new Vec(this.getDerivX(t, 1) * delta, this.getDerivY(t, 1) * delta);
                jmp.cpExit.copyFrom(jmp.p.add(v));
            }
            if (n <= 0) continue;
            delta = 0.3 * (this.tPoints.get(n - 1) - t);
            v = new Vec(this.getDerivX(t, -1) * delta, this.getDerivY(t, -1) * delta);
            jmp.cpEnter.copyFrom(jmp.p.add(v));
        }
    }

    public double getFunctionValueX(double t) {
        double[] xy = this.getFunctionValue(t);
        return xy[0];
    }

    public double getFunctionValueY(double t) {
        double[] xy = this.getFunctionValue(t);
        return xy[1];
    }

    public double getFunctionValueZ(double t) {
        double[] xyz = this.getFunctionValue(t);
        return xyz[2];
    }

    public double[] getFunctionValue(double t) {
        double[] value = new double[]{0.0, 0.0, 0.0};
        switch (this.functionType) {
            case LAMBDA_CARTESIAN: {
                value[0] = this.functionX.applyAsDouble(t);
                value[1] = this.functionY.applyAsDouble(t);
                value[2] = this.functionZ.applyAsDouble(t);
                break;
            }
            case LAMBDA_POLAR: {
                double r = this.functionX.applyAsDouble(t);
                double theta = this.functionY.applyAsDouble(t);
                value[0] = r * Math.cos(theta);
                value[1] = r * Math.sin(theta);
                value[2] = 0.0;
            }
        }
        return value;
    }

    public JMPathPoint addT(double t) {
        int n = 0;
        double x0 = this.tPoints.get(0);
        while (x0 < t) {
            x0 = this.tPoints.get(++n);
        }
        if (x0 == t) {
            return this.get(n);
        }
        this.tPoints.add(n, t);
        double x = this.getFunctionValueX(t);
        double y = this.getFunctionValueY(t);
        double z = this.getFunctionValueZ(t);
        Point p = Point.at(x, y, z);
        JMPathPoint jmp = JMPathPoint.curveTo(p);
        this.getPath().jmPathPoints.add(n, jmp);
        return jmp;
    }

    public void addTPoint(Double ... tPoints) {
        Double[] doubleArray = tPoints;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double t = doubleArray[i];
            this.addTPoint(t);
        }
        this.generateControlPoints();
    }

    public double getDerivY(double t, int direction) {
        double delta = (double)direction * 1.0E-6;
        double slope = (this.getFunctionValueY(t + delta) - this.getFunctionValueY(t)) / delta;
        return slope;
    }

    public double getDerivX(double t, int direction) {
        double delta = (double)direction * 1.0E-6;
        double slope = (this.getFunctionValueX(t + delta) - this.getFunctionValueX(t)) / delta;
        return slope;
    }

    @Override
    public ParametricCurve copy() {
        ArrayList<Double> xPointsCopy = new ArrayList<Double>(this.tPoints);
        ParametricCurve resul = new ParametricCurve(this.functionX, this.functionY, xPointsCopy);
        resul.functionType = this.functionType;
        resul.generateFunctionPoints();
        resul.getMp().copyFrom(this.getMp());
        return resul;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.functionXBackup = this.functionX;
        this.functionYBackup = this.functionY;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.functionX = this.functionXBackup;
        this.functionY = this.functionYBackup;
    }

    public Vec getTangentVector(double t0) {
        return new Vec(this.getDerivX(t0, 1), this.getDerivY(t0, 1));
    }

    public static enum FunctionDefinitionType {
        LAMBDA_CARTESIAN,
        LAMBDA_POLAR;

    }
}

