/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Shape;
import java.text.DecimalFormat;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class Point
extends MathObject {
    public final Vec v;
    private Shape dotShape;

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        Array2DRowRealMatrix pRow = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, this.v.x, this.v.y, this.v.z}});
        RealMatrix pNew = pRow.multiply(tr.getMatrix());
        this.v.x = pNew.getEntry(0, 1);
        this.v.y = pNew.getEntry(0, 2);
        this.v.z = pNew.getEntry(0, 3);
        tr.applyTransformsToDrawingProperties(this);
        return (T)this;
    }

    public static final Point origin() {
        return Point.at(0.0, 0.0);
    }

    public static final Point relAt(double x, double y) {
        return JMathAnimConfig.getConfig().getCamera().getMathView().getRelPoint(x, y);
    }

    public static final Point unitX() {
        return Point.at(1.0, 0.0);
    }

    public static final Point unitY() {
        return Point.at(0.0, 1.0);
    }

    public static final Point unitZ() {
        return new Point(0.0, 0.0, 1.0);
    }

    public static final Point segmentIntersection(Point A, Point B, Point C, Point D) {
        AffineJTransform tr = AffineJTransform.createAffineTransformation(A, B, C, Point.unitX(), Point.unitY(), Point.origin(), 1.0);
        Point P = (Point)tr.getTransformedObject(D);
        double r = P.v.x + P.v.y;
        if (r >= 1.0 & P.v.x >= 0.0 & P.v.y >= 0.0) {
            P.v.x /= r;
            P.v.y /= r;
            return (Point)tr.getInverse().getTransformedObject(P);
        }
        return null;
    }

    public Point() {
        this(0.0, 0.0, 0.0);
    }

    public Point(Vec v) {
        this(v.x, v.y, v.z);
    }

    public Point(double x, double y, double z) {
        this(x, y, z, null);
    }

    public Point(double x, double y) {
        this(x, y, 0.0, null);
    }

    public Point(double x, double y, double z, MODrawProperties mp) {
        super(mp);
        this.v = new Vec(x, y, z);
        this.getMp().loadFromStyle("dotdefault");
        this.getMp().setAbsoluteThickness(true);
    }

    public static Point at(double x, double y) {
        return new Point(x, y);
    }

    public static Point at(double x, double y, double z) {
        return new Point(x, y, z);
    }

    public static Point random() {
        Rect r = JMathAnimConfig.getConfig().getCamera().getMathView();
        double x = r.xmin + (r.xmax - r.xmin) * Math.random();
        double y = r.ymin + (r.ymax - r.ymin) * Math.random();
        return new Point(x, y);
    }

    @Override
    public Point getCenter() {
        return this.copy();
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        this.dotShape = this.generateDotShape();
        this.dotShape.setAbsoluteSize(this.copy());
        if (this.isVisible()) {
            this.dotShape.draw(scene, r);
        }
        scene.markAsAlreadyDrawed(this);
    }

    public Point dotStyle(DotSyle dotStyle) {
        this.getMp().setDotStyle(dotStyle);
        return this;
    }

    private Shape generateDotShape() {
        double st = this.scene.getRenderer().ThicknessToMathWidth(this);
        double th = this.scene.getRenderer().MathWidthToThickness(st);
        switch (this.getMp().getDotStyle()) {
            case CROSS: {
                this.dotShape = new Shape();
                this.dotShape.getPath().addPoint(Point.at(-1.0, 1.0), Point.at(1.0, -1.0), Point.at(1.0, 1.0), Point.at(-1.0, -1.0));
                this.dotShape.get((int)0).isThisSegmentVisible = false;
                this.dotShape.get((int)2).isThisSegmentVisible = false;
                ((MathObject)((MathObject)((MathObject)this.dotShape.shift(this.v)).scale(0.5 * st)).drawColor(this.getMp().getDrawColor())).thickness(0.25 * th);
                break;
            }
            case PLUS: {
                this.dotShape = new Shape();
                this.dotShape.getPath().addPoint(Point.at(0.0, 1.0), Point.at(0.0, -1.0), Point.at(1.0, 0.0), Point.at(-1.0, 0.0));
                this.dotShape.get((int)0).isThisSegmentVisible = false;
                this.dotShape.get((int)2).isThisSegmentVisible = false;
                ((MathObject)((MathObject)((MathObject)this.dotShape.shift(this.v)).scale(0.5 * st)).drawColor(this.getMp().getDrawColor())).thickness(0.25 * th);
                break;
            }
            default: {
                this.dotShape = (Shape)((MathObject)((MathObject)((MathObject)((MathObject)Shape.circle().shift(this.v)).scale(0.5 * st)).drawColor(this.getMp().getDrawColor())).fillColor(this.getMp().getDrawColor())).thickness(0.0);
            }
        }
        this.dotShape.getMp().setFaceToCamera(true);
        this.dotShape.getMp().setFaceToCameraPivot(this.v);
        return this.dotShape;
    }

    public DotSyle getDotStyle() {
        return this.getMp().getDotStyle();
    }

    public Point copy() {
        Point resul = new Point(this.v);
        resul.getMp().copyFrom(this.getMp());
        resul.visible(this.isVisible());
        return resul;
    }

    public Point add(Vec addVector) {
        Point resul = this.copy();
        resul.v.addInSite(addVector);
        return resul;
    }

    public String toString() {
        String pattern = "##0.###########";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        return this.objectLabel + "|Point(" + decimalFormat.format(this.v.x) + ",  " + decimalFormat.format(this.v.y) + ",  " + decimalFormat.format(this.v.z) + ")";
    }

    public Vec to(Point B) {
        return new Vec(B.v.x - this.v.x, B.v.y - this.v.y, B.v.z - this.v.z);
    }

    public Point interpolate(Point p2, double alpha) {
        Vec w = this.v.interpolate(p2.v, alpha);
        return new Point(w);
    }

    @Override
    public Rect getBoundingBox() {
        return new Rect(this.v.x, this.v.y, this.v.z, this.v.x, this.v.y, this.v.z);
    }

    @Override
    public void saveState() {
        super.saveState();
        this.v.saveState();
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.v.restoreState();
    }

    public void copyFrom(Point p) {
        this.v.copyFrom(p.v);
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof Point)) {
            return;
        }
        Point p2 = (Point)obj;
        this.copyFrom(p2);
        this.getMp().copyFrom(p2.getMp());
    }

    public boolean isEquivalentTo(Point p2, double epsilon) {
        boolean resul = false;
        if (Math.abs(this.v.x - p2.v.x) <= epsilon & Math.abs(this.v.y - p2.v.y) <= epsilon & Math.abs(this.v.z - p2.v.z) <= epsilon) {
            resul = true;
        }
        return resul;
    }

    public static enum DotSyle {
        CIRCLE,
        CROSS,
        PLUS;

    }

    public static enum ShadingStyle {
        NO_SHADING,
        FLAT,
        SMOOTH,
        PHONG,
        GOURAUD;

    }
}

