/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.ResourceLoader;
import com.jmathanim.Utils.SVGUtils;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SVGMathObject
extends MultiShapeObject {
    protected String filename;
    Double anchorX = null;
    Double anchorY = null;
    JMPath importJMPathTemp;

    public static SVGMathObject make(String fname) {
        return new SVGMathObject(fname);
    }

    public SVGMathObject() {
    }

    public SVGMathObject(String fname) {
        this.fillColor("black");
        this.drawColor("black");
        double defaultThickness = this.scene.getRenderer().MathWidthToThickness(1.0);
        this.getMp().setThickness(defaultThickness);
        ResourceLoader rl = new ResourceLoader();
        URL urlImage = rl.getResource(fname, "images");
        try {
            SVGUtils svgu = new SVGUtils(this.scene);
            svgu.importSVG(urlImage, this);
        }
        catch (Exception ex) {
            Logger.getLogger(SVGMathObject.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.getMp().setAbsoluteThickness(false);
        this.stackTo(new Point(0.0, 0.0), Anchor.Type.UL);
    }

    public SVGMathObject(URL url) {
        try {
            SVGUtils svgu = new SVGUtils(this.scene);
            svgu.importSVG(url, this);
        }
        catch (Exception ex) {
            Logger.getLogger(SVGMathObject.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public SVGMathObject copy() {
        SVGMathObject resul = new SVGMathObject();
        resul.getMp().copyFrom(this.getMp());
        for (Shape sh : this.shapes) {
            Shape copy = sh.copy();
            resul.add(copy);
        }
        resul.absoluteSize = this.absoluteSize;
        return resul;
    }
}

