/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Renderers.FXRenderer.FXPathUtils;
import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

public class Shape
extends MathObject {
    private final JMPath jmpath;
    private boolean showDebugPoints = false;
    private boolean isConvex = false;

    public Shape() {
        this(new JMPath(), null);
    }

    public Shape(JMPath jmpath) {
        this(jmpath, null);
    }

    public Shape(JMPath jmpath, MODrawProperties mp) {
        super(mp);
        this.jmpath = jmpath;
    }

    public Shape(MODrawProperties mp) {
        super(mp);
        this.jmpath = new JMPath();
    }

    public JMPathPoint get(int n) {
        return this.jmpath.jmPathPoints.get(n);
    }

    public Point getPoint(int n) {
        return this.get((int)n).p;
    }

    public JMPath getPath() {
        return this.jmpath;
    }

    public Point getPointAt(double t) {
        return this.jmpath.getJMPointAt((double)t).p;
    }

    public Point getCentroid() {
        Point resul = new Point(0.0, 0.0, 0.0);
        for (JMPathPoint p : this.jmpath.jmPathPoints) {
            resul.v.x += p.p.v.x;
            resul.v.y += p.p.v.y;
            resul.v.z += p.p.v.z;
        }
        resul.v.x /= (double)this.jmpath.size();
        resul.v.y /= (double)this.jmpath.size();
        resul.v.z /= (double)this.jmpath.size();
        return resul;
    }

    public void removeInterpolationPoints() {
        this.jmpath.removeInterpolationPoints();
    }

    public Shape copy() {
        MODrawProperties copy = this.getMp().copy();
        Shape resul = new Shape(this.jmpath.copy(), copy);
        resul.absoluteSize = this.absoluteSize;
        resul.objectLabel = this.objectLabel + "_copy";
        resul.isConvex = this.isConvex;
        resul.showDebugPoints = this.showDebugPoints;
        return resul;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof Shape)) {
            return;
        }
        Shape sh2 = (Shape)obj;
        this.getMp().copyFrom(sh2.getMp());
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).copyStateFrom(sh2.get(i));
        }
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible()) {
            if (this.absoluteSize) {
                r.drawAbsoluteCopy(this, this.getAbsoluteAnchor().v);
            } else {
                r.drawPath(this);
                if (this.isShowDebugPoints()) {
                    for (int n = 0; n < this.size(); ++n) {
                        r.debugText("" + n, this.getPoint((int)n).v);
                    }
                }
            }
        }
    }

    @Override
    public Rect getBoundingBox() {
        return this.jmpath.getBoundingBox();
    }

    public String toString() {
        return this.objectLabel + ":" + this.jmpath.toString();
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.jmpath.restoreState();
        this.getMp().restoreState();
    }

    @Override
    public void saveState() {
        super.saveState();
        this.jmpath.saveState();
        this.getMp().saveState();
    }

    public <T extends Shape> T merge(Shape sh, boolean connectAtoB, boolean connectBtoA) {
        this.getPath().merge(sh.getPath().copy(), connectAtoB, connectBtoA);
        return (T)this;
    }

    public int size() {
        return this.jmpath.size();
    }

    public static Shape square() {
        Shape obj = Shape.square(new Point(0.0, 0.0), 1.0);
        obj.objectLabel = "square";
        return obj;
    }

    public static Shape square(Point A, double side) {
        return Shape.rectangle(A, A.add(new Vec(side, side)));
    }

    public static Shape rectangle(Rect r) {
        return Shape.rectangle(r.getDL(), r.getUR());
    }

    public static Shape segment(Point A, Vec v) {
        return Shape.segment(A, A.add(v));
    }

    public static Shape segment(Point A, Point B) {
        Shape obj = new Shape();
        JMathAnimConfig.getConfig().getScene();
        JMPathPoint p1 = JMPathPoint.lineTo(A);
        p1.isThisSegmentVisible = false;
        JMPathPoint p2 = JMPathPoint.lineTo(B);
        obj.jmpath.addJMPoint(p1, p2);
        return obj;
    }

    public static Shape rectangle(Point A, Point B) {
        Shape obj = new Shape();
        JMPathPoint p1 = JMPathPoint.lineTo(A);
        JMPathPoint p2 = JMPathPoint.lineTo(B.v.x, A.v.y);
        JMPathPoint p3 = JMPathPoint.lineTo(B);
        JMPathPoint p4 = JMPathPoint.lineTo(A.v.x, B.v.y);
        obj.jmpath.addJMPoint(p1, p2, p3, p4);
        return obj;
    }

    public static Shape rectangle(Point A, Point B, Point C) {
        Shape obj = new Shape();
        JMPathPoint p1 = JMPathPoint.lineTo(B);
        JMPathPoint p2 = JMPathPoint.lineTo(C);
        JMPathPoint p3 = JMPathPoint.lineTo(C.add(B.to(A)));
        JMPathPoint p4 = JMPathPoint.lineTo(A);
        obj.jmpath.addJMPoint(p1, p2, p3, p4);
        return obj;
    }

    public static Shape polygon(Point ... points) {
        Shape obj = new Shape();
        for (Point newPoint : points) {
            JMPathPoint p = JMPathPoint.lineTo(newPoint);
            obj.getPath().addJMPoint(p);
        }
        return obj;
    }

    public static Shape polyLine(Point ... points) {
        Shape obj = Shape.polygon(points);
        obj.objectLabel = "polyLine";
        obj.get((int)0).isThisSegmentVisible = false;
        return obj;
    }

    public static Shape triangle() {
        return Shape.polygon(Point.at(0.0, 0.0), Point.at(1.0, 0.0), Point.at(0.0, 1.0));
    }

    public static Shape regularInscribedPolygon(int numSides) {
        Point[] points = new Point[numSides];
        for (int i = 0; i < numSides; ++i) {
            points[i] = Point.at(Math.cos(Math.PI * 2 * (double)i / (double)numSides), Math.sin(Math.PI * 2 * (double)i / (double)numSides));
        }
        return Shape.polygon(points);
    }

    public static Shape regularPolygon(int numsides) {
        return Shape.regularPolygon(numsides, new Point(0.0, 0.0), 1.0);
    }

    private static Shape regularPolygon(int numsides, Point A, double side) {
        Shape obj = new Shape();
        obj.objectLabel = "regPol";
        Point newPoint = A.copy();
        for (int n = 0; n < numsides; ++n) {
            double alpha = (double)(2 * n) * Math.PI / (double)numsides;
            Vec moveVector = new Vec(side * Math.cos(alpha), side * Math.sin(alpha));
            newPoint = newPoint.add(moveVector);
            JMPathPoint p = JMPathPoint.lineTo(newPoint);
            obj.getPath().addJMPoint(p);
        }
        return obj;
    }

    public static Shape arc(double angle) {
        Shape obj = new Shape();
        obj.objectLabel = "arc";
        int nSegs = 4;
        int segsForFullCircle = (int)(Math.PI * 2 * (double)nSegs / angle);
        double cte = 1.3333333333333333 * Math.tan(1.5707963267948966 / (double)segsForFullCircle);
        for (int n = 0; n < nSegs + 1; ++n) {
            double alphaC = angle * (double)n / (double)nSegs;
            double x1 = Math.cos(alphaC);
            double y1 = Math.sin(alphaC);
            Point p = new Point(x1, y1);
            Vec v1 = new Vec(-y1, x1);
            v1.multInSite(cte);
            Point cp1 = p.add(v1);
            Point cp2 = p.add(v1.multInSite(-1.0));
            JMPathPoint jmp = JMPathPoint.curveTo(p);
            jmp.cpExit.copyFrom(cp1);
            jmp.cpEnter.copyFrom(cp2);
            obj.jmpath.addJMPoint(jmp);
        }
        obj.getPath().jmPathPoints.get((int)0).isThisSegmentVisible = false;
        return obj;
    }

    public static Shape circle() {
        return Shape.circle(4);
    }

    public static Shape circle(int numSegments) {
        Shape obj = new Shape();
        obj.objectLabel = "circle";
        double step = Math.PI * 2 / (double)numSegments;
        double cte = 1.3333333333333333 * Math.tan(1.5707963267948966 / (double)numSegments);
        for (double alphaC = 0.0; alphaC < Math.PI * 2; alphaC += step) {
            double x1 = Math.cos(alphaC);
            double y1 = Math.sin(alphaC);
            Point p = new Point(x1, y1);
            Vec v1 = new Vec(-y1, x1);
            v1.multInSite(cte);
            Point cp1 = p.add(v1);
            Point cp2 = p.add(v1.multInSite(-1.0));
            JMPathPoint jmp = JMPathPoint.curveTo(p);
            jmp.cpExit.copyFrom(cp1);
            jmp.cpEnter.copyFrom(cp2);
            obj.jmpath.addJMPoint(jmp);
        }
        return obj;
    }

    public static Shape annulus(double minRadius, double maxRadius) {
        Shape extCircle = (Shape)Shape.circle().scale(maxRadius);
        Shape intCircle = (Shape)Shape.circle().scale(minRadius);
        Object obj = extCircle.merge(intCircle.reverse(), false, false);
        ((Shape)obj).objectLabel = "annulus";
        return obj;
    }

    public boolean isShowDebugPoints() {
        return this.showDebugPoints;
    }

    public void setShowDebugPoints(boolean showDebugPoints) {
        this.showDebugPoints = showDebugPoints;
    }

    @Override
    public <T extends MathObject> T applyAffineTransform(AffineJTransform tr) {
        int size = this.getPath().size();
        for (int n = 0; n < size; ++n) {
            this.get(n).applyAffineTransform(tr);
        }
        tr.applyTransformsToDrawingProperties(this);
        return (T)this;
    }

    public boolean containsPoint(Point p) {
        return this.containsPoint(p.v);
    }

    public boolean containsPoint(Vec v) {
        FXPathUtils fXPathUtils = new FXPathUtils();
        Camera dummyCamera = JMathAnimConfig.getConfig().getCamera();
        Path path = FXPathUtils.createFXPathFromJMPath(this.jmpath, dummyCamera);
        path.setFill((Paint)JMColor.parse("black").getFXColor());
        double[] xy = dummyCamera.mathToScreenFX(v);
        return path.contains(xy[0], xy[1]);
    }

    public JMPath getIntersectionPath(Shape s2) {
        FXPathUtils fXPathUtils = new FXPathUtils();
        Camera dummyCamera = this.scene.getCamera();
        Path path = FXPathUtils.createFXPathFromJMPath(this.jmpath, dummyCamera);
        Path path2 = FXPathUtils.createFXPathFromJMPath(s2.getPath(), dummyCamera);
        path.setFill((Paint)JMColor.parse("black").getFXColor());
        path2.setFill((Paint)JMColor.parse("black").getFXColor());
        javafx.scene.shape.Shape newpa = Path.intersect((javafx.scene.shape.Shape)path, (javafx.scene.shape.Shape)path2);
        Path convertToPath = this.convertToPath(newpa);
        FXPathUtils ut = new FXPathUtils();
        ut.distille(convertToPath);
        return ut.createJMPathFromFXPath(convertToPath, dummyCamera);
    }

    public Shape intersect(Shape s2) {
        Shape resul = new Shape(this.getIntersectionPath(s2));
        resul.getMp().copyFrom(this.getMp());
        return resul;
    }

    public JMPath getUnionPath(Shape s2) {
        FXPathUtils fXPathUtils = new FXPathUtils();
        Camera dummyCamera = this.scene.getCamera();
        Path path = FXPathUtils.createFXPathFromJMPath(this.jmpath, dummyCamera);
        Path path2 = FXPathUtils.createFXPathFromJMPath(s2.getPath(), dummyCamera);
        path.setFill((Paint)JMColor.parse("black").getFXColor());
        path2.setFill((Paint)JMColor.parse("black").getFXColor());
        javafx.scene.shape.Shape newpa = Path.union((javafx.scene.shape.Shape)path, (javafx.scene.shape.Shape)path2);
        Path convertToPath = this.convertToPath(newpa);
        fXPathUtils.distille(convertToPath);
        return fXPathUtils.createJMPathFromFXPath(convertToPath, dummyCamera);
    }

    public Shape union(Shape s2) {
        Shape resul = new Shape(this.getUnionPath(s2));
        resul.getMp().copyFrom(this.getMp());
        return resul;
    }

    public JMPath getSubstractPath(Shape s2) {
        FXPathUtils fXPathUtils = new FXPathUtils();
        Camera dummyCamera = this.scene.getCamera();
        Path path = FXPathUtils.createFXPathFromJMPath(this.jmpath, dummyCamera);
        Path path2 = FXPathUtils.createFXPathFromJMPath(s2.getPath(), dummyCamera);
        path.setFill((Paint)JMColor.parse("black").getFXColor());
        path2.setFill((Paint)JMColor.parse("black").getFXColor());
        javafx.scene.shape.Shape newpa = Path.subtract((javafx.scene.shape.Shape)path, (javafx.scene.shape.Shape)path2);
        Path convertToPath = this.convertToPath(newpa);
        return fXPathUtils.createJMPathFromFXPath(convertToPath, dummyCamera);
    }

    public Shape substract(Shape s2) {
        Shape resul = new Shape(this.getSubstractPath(s2));
        resul.getMp().copyFrom(this.getMp());
        return resul;
    }

    private Path convertToPath(javafx.scene.shape.Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Path) {
            return (Path)shape;
        }
        return (Path)javafx.scene.shape.Shape.union((javafx.scene.shape.Shape)new Path(), (javafx.scene.shape.Shape)shape);
    }

    private void writeFXPathPoints(Path pa) {
        System.out.println("FXPATH");
        System.out.println("-----------------------");
        int counter = 0;
        for (PathElement el : pa.getElements()) {
            System.out.println(counter + ":  " + el);
            ++counter;
        }
        System.out.println("-----------------------");
    }

    public boolean isIsConvex() {
        return this.isConvex;
    }

    public void setIsConvex(boolean isConvex) {
        this.isConvex = isConvex;
    }

    public Vec getNormalVector() {
        if (this.size() < 3) {
            return Vec.to(0.0, 0.0, 0.0);
        }
        Vec v1 = this.get((int)(this.size() / 3)).p.to(this.get((int)0).p);
        Vec v2 = this.get((int)(this.size() / 3)).p.to(this.get((int)(this.size() / 2)).p);
        return v1.cross(v2);
    }

    public Shape reverse() {
        this.getPath().reverse();
        return this;
    }

    public Shape getSubShape(double a, double b) {
        Shape subShape = new Shape();
        subShape.getMp().copyFrom(this.getMp());
        JMPath subPath = this.getPath().getSubPath(a, b);
        subShape.getPath().jmPathPoints.addAll(subPath.jmPathPoints);
        return subShape;
    }
}

