/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Text;

import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import com.jmathanim.mathobjects.Text.JMNumberLength;
import com.jmathanim.mathobjects.Text.LaTeXMathObject;
import java.text.DecimalFormat;

public class JMNumber
extends LaTeXMathObject {
    private final AffineJTransform modelMatrix;
    private double number;
    private final DecimalFormat formatter;
    private int numDecimals;
    private static final String SYMBOLS = "0123456789.,-abcdefghijklmnopqrstuvwxyz";
    private static final double[][] GAPS = new double[][]{{0.014468161764682463, 0.023624981617672347, 0.016482647058808197, 0.015017555147096573, 0.01245363970588187, 0.01648266544117405, 0.015017573529405581, 0.017581488970620285, 0.015017573529405581, 0.015017573529405581, 0.02307558823531508, 0.02307558823531508, 0.009340312500000891, 0.01501755514703973, 0.012453658088247721, 0.013552463235328105, 0.013552463235271262, 0.01245363970588187, 0.013369338235293071, 0.012453658088247721, 0.01318619485294903, 0.01336931985292722, 3.4926466696560965E-7, 0.012453658088247721, 0.013369319852984063, 0.013186194852892186, 0.01318619485294903, 0.01245363970588187, 0.01245363970588187, 0.013552463235271262, 0.012453658088190878, 0.013369338235293071, 0.01080540441176936, 0.013186213235314881, 0.010805422794135211, 0.010622279411791169, 0.009523455882344933, 0.01080540441176936, 0.012453658088247721}, {0.021976764705868845, 0.03113360294122458, 0.02399126838236043, 0.02252615808822611, 0.01996224264706825, 0.02399126838236043, 0.022526176470591963, 0.025090091911806667, 0.022526176470591963, 0.022526176470591963, 0.030584191176501463, 0.030584191176501463, 0.016848933823553125, 0.02252615808822611, 0.01996226102937726, 0.021061066176457643, 0.021061066176457643, 0.01996224264706825, 0.02087794117642261, 0.019962261029434103, 0.02069481617644442, 0.020877941176479453, 0.0075089522058533476, 0.019962261029434103, 0.020877941176479453, 0.020694797794078568, 0.020694816176501263, 0.019962261029434103, 0.019962261029434103, 0.021061084558823495, 0.01996226102937726, 0.020877941176479453, 0.018314025735321593, 0.020694816176501263, 0.018314025735321593, 0.01813088235297755, 0.017032058823531315, 0.018314025735321593, 0.01996226102937726}, {0.01648266544117405, 0.025639485294163933, 0.018497150735299783, 0.017032058823531315, 0.014468143382316612, 0.018497169117665635, 0.017032077205897167, 0.019595992647055027, 0.017032077205897167, 0.017032077205897167, 0.025090091911749823, 0.025090091911749823, 0.011354834558801485, 0.017032058823531315, 0.014468161764682463, 0.015566966911762847, 0.015566966911762847, 0.014468143382373455, 0.015383841911727814, 0.014468161764739307, 0.015200698529383772, 0.015383823529418805, 0.0020148529411585514, 0.014468161764682463, 0.015383823529418805, 0.015200698529383772, 0.015200698529440615, 0.014468143382373455, 0.014468143382373455, 0.015566966911762847, 0.014468161764682463, 0.015383841911727814, 0.012819908088260945, 0.015200716911806467, 0.012819926470569953, 0.012636783088225911, 0.01153795955883652, 0.012819908088260945, 0.014468161764682463}, {0.01501755514703973, 0.024174393382395465, 0.017032058823531315, 0.015566966911762847, 0.013003051470604987, 0.017032077205897167, 0.015566985294128699, 0.01813090073528656, 0.015566985294128699, 0.015566985294128699, 0.023624981617672347, 0.0236250000000382, 0.009889724264724009, 0.015566966911762847, 0.013003069852913995, 0.01410187499999438, 0.01410187499999438, 0.013003051470604987, 0.013918731617593494, 0.013003051470604987, 0.013735606617615304, 0.013918731617650337, 5.497610293900834E-4, 0.013003069852913995, 0.013918731617650337, 0.013735606617615304, 0.013735606617672147, 0.013003051470604987, 0.013003051470604987, 0.01410187499999438, 0.013003069852913995, 0.013918750000016189, 0.011354816176492477, 0.013735606617672147, 0.011354816176492477, 0.011171691176457443, 0.010072867647068051, 0.011354816176492477, 0.013003069852913995}, {0.012453658088247721, 0.02161047794118076, 0.014468143382373455, 0.013003051470604987, 0.010439136029390284, 0.014468161764739307, 0.013003069852970839, 0.015566985294128699, 0.013003069852913995, 0.013003069852970839, 0.021061066176457643, 0.021061084558823495, 0.0073258088235093055, 0.013003051470604987, 0.010439154411756135, 0.01153795955883652, 0.01153795955883652, 0.010439136029390284, 0.011354816176435634, 0.010439154411756135, 0.011171691176457443, 0.011354816176492477, -0.0020141544117677768, 0.010439154411756135, 0.011354816176492477, 0.011171691176457443, 0.011171691176514287, 0.010439136029390284, 0.010439136029447127, 0.01153795955883652, 0.010439154411756135, 0.011354834558801485, 0.008790900735277773, 0.011171709558823295, 0.008790919117643625, 0.008607775735299583, 0.007508952205910191, 0.008790900735277773, 0.010439154411756135}, {0.01648266544117405, 0.025639485294163933, 0.018497150735299783, 0.017032058823531315, 0.014468143382316612, 0.018497169117665635, 0.017032077205897167, 0.019595992647055027, 0.017032077205897167, 0.017032077205897167, 0.025090091911749823, 0.025090091911749823, 0.011354834558801485, 0.017032058823531315, 0.014468161764682463, 0.015566966911762847, 0.015566966911762847, 0.014468143382373455, 0.015383841911727814, 0.014468161764739307, 0.015200698529383772, 0.015383823529418805, 0.0020148529411585514, 0.014468161764682463, 0.015383823529418805, 0.015200698529383772, 0.015200698529440615, 0.014468143382373455, 0.014468143382373455, 0.015566966911762847, 0.014468161764682463, 0.015383841911727814, 0.012819908088260945, 0.015200716911806467, 0.012819926470569953, 0.012636783088225911, 0.01153795955883652, 0.012819908088260945, 0.014468161764682463}, {0.01501755514703973, 0.024174393382395465, 0.017032058823531315, 0.015566966911762847, 0.013003051470604987, 0.017032077205897167, 0.015566985294128699, 0.01813090073528656, 0.015566985294128699, 0.015566985294128699, 0.023624981617672347, 0.0236250000000382, 0.009889724264724009, 0.015566966911762847, 0.013003069852913995, 0.01410187499999438, 0.01410187499999438, 0.013003051470604987, 0.013918731617593494, 0.013003051470604987, 0.013735606617615304, 0.013918731617650337, 5.497610293900834E-4, 0.013003069852913995, 0.013918731617650337, 0.013735606617615304, 0.013735606617672147, 0.013003051470604987, 0.013003051470604987, 0.01410187499999438, 0.013003069852913995, 0.013918750000016189, 0.011354816176492477, 0.013735606617672147, 0.011354816176492477, 0.011171691176457443, 0.010072867647068051, 0.011354816176492477, 0.013003069852913995}, {0.009889742647033017, 0.0190465625000229, 0.011904227941158751, 0.010439136029447127, 0.007875220588232423, 0.011904246323524603, 0.010439154411812979, 0.013003069852970839, 0.010439154411756135, 0.010439154411756135, 0.018497169117665635, 0.018497169117665635, 0.004761893382351445, 0.010439136029390284, 0.007875238970598275, 0.008974044117678659, 0.008974044117621816, 0.007875220588232423, 0.008790919117643625, 0.007875238970598275, 0.008607775735299583, 0.008790900735277773, -0.00457806985298248, 0.007875238970598275, 0.008790900735334617, 0.00860777573524274, 0.008607775735299583, 0.007875220588232423, 0.007875220588232423, 0.008974044117621816, 0.007875238970598275, 0.008790919117643625, 0.006226985294119913, 0.008607794117665435, 0.006227003676485765, 0.006043860294141723, 0.004945036764695487, 0.006226985294119913, 0.007875238970598275}, {0.01501755514703973, 0.024174393382395465, 0.017032058823531315, 0.015566966911762847, 0.013003051470604987, 0.017032077205897167, 0.015566985294128699, 0.01813090073528656, 0.015566985294128699, 0.015566985294128699, 0.023624981617672347, 0.0236250000000382, 0.009889724264724009, 0.015566966911762847, 0.013003069852913995, 0.01410187499999438, 0.01410187499999438, 0.013003051470604987, 0.013918731617593494, 0.013003051470604987, 0.013735606617615304, 0.013918731617650337, 5.497610293900834E-4, 0.013003069852913995, 0.013918731617650337, 0.013735606617615304, 0.013735606617672147, 0.013003051470604987, 0.013003051470604987, 0.01410187499999438, 0.013003069852913995, 0.013918750000016189, 0.011354816176492477, 0.013735606617672147, 0.011354816176492477, 0.011171691176457443, 0.010072867647068051, 0.011354816176492477, 0.013003069852913995}, {0.01501755514703973, 0.024174393382395465, 0.017032058823531315, 0.015566966911762847, 0.013003051470604987, 0.017032077205897167, 0.015566985294128699, 0.01813090073528656, 0.015566985294128699, 0.015566985294128699, 0.023624981617672347, 0.0236250000000382, 0.009889724264724009, 0.015566966911762847, 0.013003069852913995, 0.01410187499999438, 0.01410187499999438, 0.013003051470604987, 0.013918731617593494, 0.013003051470604987, 0.013735606617615304, 0.013918731617650337, 5.497610293900834E-4, 0.013003069852913995, 0.013918731617650337, 0.013735606617615304, 0.013735606617672147, 0.013003051470604987, 0.013003051470604987, 0.01410187499999438, 0.013003069852913995, 0.013918750000016189, 0.011354816176492477, 0.013735606617672147, 0.011354816176492477, 0.011171691176457443, 0.010072867647068051, 0.011354816176492477, 0.013003069852913995}, {0.022851544117656886, 0.032008400735264786, 0.02486606617645748, 0.023400974264689012, 0.0208370404411653, 0.024866047794091628, 0.023400974264689012, 0.025964871323537864, 0.023400974264689012, 0.02340095588232316, 0.03145898897059851, 0.03145898897059851, 0.01772373161759333, 0.023400955882380003, 0.02083705882353115, 0.021935863970554692, 0.021935863970611535, 0.02083705882353115, 0.02175272058821065, 0.0208370404411653, 0.02156959558823246, 0.021752738970576502, 0.00838375000000724, 0.02083705882353115, 0.021752738970576502, 0.02156959558823246, 0.02156959558823246, 0.02083705882353115, 0.020837040441222143, 0.021935882352920544, 0.02083705882353115, 0.021752738970576502, 0.01918880514705279, 0.02156959558823246, 0.01918882352941864, 0.0190056801470746, 0.017906856617628364, 0.01918880514705279, 0.0208370404411653}, {0.020837040441222143, 0.0299938970587732, 0.022851562500022737, 0.021386452205888418, 0.018822536764730557, 0.022851544117656886, 0.021386470588197426, 0.02395036764710312, 0.021386470588197426, 0.021386452205888418, 0.029444485294106926, 0.029444485294106926, 0.015709227941158588, 0.021386452205888418, 0.018822555147039566, 0.01992136029411995, 0.01992136029411995, 0.018822555147039566, 0.019738216911775908, 0.018822536764730557, 0.019555091911797717, 0.019738235294084916, 0.006369246323515654, 0.018822555147039566, 0.019738235294084916, 0.019555091911740874, 0.019555091911740874, 0.018822555147039566, 0.018822536764730557, 0.019921378676428958, 0.01882255514709641, 0.019738235294084916, 0.017174301470561204, 0.019555091911740874, 0.0171743198529839, 0.016991176470583014, 0.015892352941136778, 0.017174301470618047, 0.018822536764673714}, {0.01764227941180252, 0.02679913602941042, 0.019656783088237262, 0.018191709558834646, 0.015627794117676785, 0.019656783088237262, 0.018191709558834646, 0.020755606617626654, 0.018191709558834646, 0.018191709558834646, 0.026249724264744145, 0.026249705882378294, 0.007875404411777254, 0.015627794117619942, 0.01672659926475717, 0.016726599264700326, 0.01562777573525409, 0.016543474264722136, 0.015627794117676785, 0.01636033088232125, 0.016543474264722136, 0.00317448529409603, 0.015627794117676785, 0.016543474264722136, 0.01636033088232125, 0.016360330882378094, 0.015627775735310934, 0.015627794117619942, 0.01672659926475717, 0.015627794117676785, 0.016543474264665292, 0.013979558823564275, 0.01636033088232125, 0.013979558823507432, 0.01379641544116339, 0.01269761029413985, 0.013979558823564275, 0.015627794117676785}, {0.008424632352955541, 0.017581470588254433, 0.010439136029390284, 0.008974044117678659, 0.006410128676463955, 0.010439154411756135, 0.00897406250004451, 0.01153797794120237, 0.008974062499987667, 0.008974044117678659, 0.017032058823531315, 0.017032077205897167, 0.0032968014705829773, 0.008974044117678659, 0.006410147058829807, 0.007508952205910191, 0.0075089522058533476, 0.006410128676463955, 0.0073258088235093055, 0.006410128676463955, 0.007142683823531115, 0.007325808823566149, 0.004130863970544851, 0.006410128676463955, 0.0073258088235093055, 0.007142683823531115, 0.0071426654411652635, 0.006410128676463955, 0.006410128676463955, 0.007508952205910191, 0.006410147058829807, 0.007325808823566149, 0.004761893382351445, 0.007142683823531115, -3.253676470080791E-4, -5.085294117748163E-4, 0.0034799448529270194, -3.253860294307742E-4, 0.006410147058829807}, {0.013471047794098467, 0.02262788602939736, 0.015485551470590053, 0.014020459558821585, 0.011456544117663725, 0.015485551470590053, 0.014020459558821585, 0.016584374999979445, 0.014020459558821585, 0.014020459558821585, 0.022078474264731085, 0.022078455882365233, 0.008343216911782747, 0.014020441176455734, 0.011456525735297873, 0.017642628676469485, 0.017642628676469485, 0.0165438235293891, 0.012372224264709075, 0.011456525735297873, 0.012189080882365033, 0.012372224264709075, 0.009177242647069761, 0.011456525735297873, 0.012372224264709075, 0.012189080882365033, 0.01218908088230819, 0.0165438235293891, 0.011456525735297873, 0.017642628676469485, 0.011456525735297873, 0.012372224264709075, 0.009808290441185363, 0.012189080882365033, 0.004721011029459987, 0.00453788602936811, 0.003439062499978718, 0.004721011029403144, 0.011456525735297873}, {0.012534908088241536, 0.02169174632354043, 0.014549411764676279, 0.013084319852964654, 0.010520404411806794, 0.014549411764676279, 0.013084319852964654, 0.015648216911756663, 0.01308431985290781, 0.013084319852964654, 0.02114233455881731, 0.02114233455881731, 0.007407077205868973, 0.01308431985290781, 0.01052040441174995, 0.011619227941196186, 0.011619227941139343, 0.010520404411806794, 0.011436084558852144, 0.010520404411806794, 0.006165661764725883, 0.011436102941217996, -0.0019329044117739613, 0.0054331250000245745, 0.011436102941161153, 0.011252941176508102, 0.011252941176508102, 0.010520404411806794, 0.010520404411806794, 0.011619227941139343, 0.01052040441174995, 0.011436084558852144, 0.00887216911763744, 0.011252941176451259, 0.00887216911763744, 0.008689025735293399, 0.007590220588213015, 0.008872187500003292, 0.010520386029384099}, {0.012372224264709075, 0.021529062499951124, 0.014386727941143818, 0.01292163602937535, 0.01035772058821749, 0.014386727941200661, 0.012921636029432193, 0.01548555147053321, 0.01292163602937535, 0.01292163602937535, 0.02097965073528485, 0.02097963235297584, 0.007244393382336511, 0.012921636029432193, 0.01035772058821749, 0.011456525735297873, 0.011456544117663725, 0.01035772058821749, 0.01127340073526284, 0.010357702205851638, 0.011090257352918798, 0.011273382352953831, -0.0020955882353064226, 0.010357702205908481, 0.011273400735319683, 0.011090257352975641, 0.011090257352975641, 0.01035772058821749, 0.010357702205908481, 0.011456525735297873, 0.01035772058821749, 0.011273382352953831, 0.00870948529410498, 0.011090257352918798, 0.00870948529410498, 0.008526341911760937, 0.007427518382371545, 0.00870948529410498, 0.01035772058821749}, {0.012534908088241536, 0.02169174632354043, 0.014549411764733122, 0.013084319852964654, 0.01052040441174995, 0.014549411764733122, 0.013084319852964654, 0.015648216911756663, 0.013084319852964654, 0.013084319852964654, 0.02114233455881731, 0.021142334558874154, 0.007407077205868973, 0.013084319852964654, 0.01052040441174995, 0.011619227941196186, 0.011619227941196186, 0.01052040441174995, 0.0114360845587953, 0.01052040441174995, 0.011252959558873954, 0.011436084558852144, -0.0019329044117739613, 0.01052040441174995, 0.0114360845587953, 0.01125295955881711, 0.011252941176451259, 0.01052040441174995, 0.01052040441174995, 0.011619227941196186, 0.01052040441174995, 0.0114360845587953, 0.008872169117694284, 0.01125295955881711, 0.00887216911763744, 0.008689025735293399, 0.007590220588213015, 0.00887216911763744, 0.01052040441174995}, {-0.0022787316176504646, 0.006878125000014279, -2.642095588498705E-4, -0.0017293014706183385, -0.004293216911776199, -2.642095588498705E-4, -0.001729301470561495, 8.346139705963651E-4, -0.001729301470561495, -0.001729301470561495, 0.006328713235291161, 0.006328694852982153, -0.007406562499966185, -0.0017293014706183385, -0.004293216911719355, -0.003194411764752658, -0.003194411764752658, -0.00429323529414205, -0.002136139705896767, 0.008790919117643625, 0.00870948529410498, -0.01674652573530011, -0.004293216911776199, 0.011273400735319683, 0.009767775735269879, 0.009808290441185363, 0.011354816176492477, 0.012372205882343223, 0.0061861213235374635, 0.011110606617648955, 0.012351746323531643, 0.01646220588236247, 0.009808290441185363, 0.009666066176464483, 0.009564172794114256, 0.008200955882330163, 0.009666066176464483}, {0.009889742647033017, 0.0190465625000229, 0.011904227941158751, 0.010439136029390284, 0.007875220588232423, 0.011904246323524603, 0.010439154411756135, 0.013003069852970839, 0.010439154411756135, 0.010439154411756135, 0.01849716911760879, 0.018497169117665635, 0.004761893382351445, 0.010439136029390284, 0.007875238970541432, 0.008974044117621816, 0.008974044117621816, 0.007875220588232423, 0.008790919117643625, 0.007875238970598275, 0.008607775735299583, 0.008790900735277773, 5.092279411655909E-4, 0.007875238970598275, 0.008790919117643625, 0.008607775735299583, 0.008607775735299583, 0.007875238970598275, 0.007875238970541432, 0.008974062499987667, 0.007875220588232423, 0.008790919117643625, 0.006227003676485765, 0.008607775735299583, 0.006227003676485765, 0.006043878676507575, 0.004945036764695487, 0.006227003676485765, 0.007875220588232423}, {0.010907132352940607, 0.0200639705882395, 0.012921636029432193, 0.011456544117606882, 0.008892628676449021, 0.012921636029432193, 0.011456544117663725, 0.014020459558821585, 0.011456544117663725, 0.011456544117606882, 0.01951455882351638, 0.019514540441207373, 0.0057793014705680434, 0.01145652573524103, 0.0038053308823577936, 0.009991433823529405, 0.009991433823529405, 0.00889261029408317, 0.009808290441185363, 0.00889261029408317, 0.00962516544115033, 0.009808308823494372, -0.0035606801470748906, 0.008892610294140013, 0.009808308823494372, 0.009625165441207173, 0.009625165441207173, 0.00889261029408317, 0.008892610294140013, 0.009991433823529405, 0.008892628676449021, 0.009808290441185363, 0.0021571139706111353, 0.004537867647059102, 0.0021570955882452836, 0.0019739705882670933, 0.005962426470546234, 0.0021570955882452836, 0.008892628676449021}, {0.012779025735312644, 0.021935863970611535, 0.014793547794170081, 0.013328437500035761, 0.010764522058877901, 0.01479352941180423, 0.013328455882401613, 0.01589235294119362, 0.013328455882401613, 0.013328437500035761, 0.02138647058825427, 0.021386470588197426, 0.0076512132353059314, 0.013328437499978918, 0.010764522058821058, 0.011863345588267293, 0.011863345588267293, 0.010764522058821058, 0.010581378676477016, 0.008790919117643625, 0.009808308823551215, 0.01168022058823226, 0.02354356617644271, 0.009116654411798208, 0.01021511029409794, 0.00976775735296087, 0.00980829044112852, 0.011354834558801485, 0.012372205882343223, 0.006186102941171612, 0.011110606617648955, 0.012351727941165791, 0.01646222426472832, 0.009808308823551215, 0.009666066176464483, 0.009564191176480108, 0.008200974264752858, 0.009666047794098631}, {0.024642389705888945, 0.033799227941130994, 0.02665689338238053, 0.02519180147055522, 0.022627886029454203, 0.02665689338238053, 0.02519180147055522, 0.027755716911769923, 0.02519180147055522, 0.025191801470612063, 0.03324981617646472, 0.03324979779409887, 0.01951454044115053, 0.025191801470612063, 0.022627867647031508, 0.023726691176477743, 0.023726691176477743, 0.02262786764708835, 0.02354356617644271, 0.02262786764708835, 0.02336042279415551, 0.023543566176499553, 0.010174577205873447, 0.02262788602939736, 0.0235435477941337, 0.023360422794098668, 0.023360422794098668, 0.022627886029454203, 0.022627867647031508, 0.023726709558843595, 0.02262786764708835, 0.023543566176499553, 0.020979632352918998, 0.023360404411732816, 0.02097965073528485, 0.020796507352940807, 0.019697683823551415, 0.02097965073528485, 0.022627867647031508}, {0.010215459558821749, 0.01937229779412064, 0.012229981617679186, 0.010764871323544867, 0.008200974264696015, 0.012229963235313335, 0.010764889705910718, 0.01332878676475957, 0.010764871323488023, 0.010764871323544867, 0.018822886029397523, 0.018822886029397523, 0.005087628676506029, 5.905882352976732E-4, 0.008200974264696015, 0.0042124816176283275, 0.009299779411719555, 0.003113676470604787, 0.009116654411741365, 0.008200955882330163, 0.008933511029397323, 0.009116636029375513, -0.004252352941136905, 0.008200955882330163, 0.009116636029432357, 0.008933511029397323, 0.008933511029397323, 0.003113676470604787, 0.008200974264696015, 0.009299779411776399, 0.008200955882387007, 0.009116636029375513, 0.006552738970583505, 0.008933511029397323, 0.0065527205882744965, 0.006369595588239463, 0.005270790441215922, 0.006552738970583505, 0.008200974264696015}, {0.011313933823544176, 0.020470772058843067, 0.013328455882401613, 0.011863345588267293, 0.009299430147109433, 0.013328437500035761, 0.011863363970633145, 0.014427261029425154, 0.011863363970633145, 0.011863345588267293, 0.0199213786764858, 0.019921378676428958, 0.0061861213235374635, 0.01186334558821045, 0.00929943014705259, 0.010398253676498825, 0.010398253676498825, 0.00929943014705259, 0.009116286764708548, 0.008790919117643625, 0.009808308823551215, 0.01168022058823226, 0.02354356617644271, 0.009116654411798208, 0.01021511029409794, 0.00976775735296087, 0.00980829044112852, 0.011354834558801485, 0.012372205882343223, 0.006186102941171612, 0.011110606617648955, 0.012351727941165791, 0.01646222426472832, 0.009808308823551215, 0.009666066176464483, 0.009564191176480108, 0.008200974264752858, 0.009666047794098631}, {0.010866580882350263, 0.020023419117649155, 0.012881084558841849, 0.01141599264707338, 0.008852077205858677, 0.012881084558841849, 0.01141599264707338, 0.013979908088288084, 0.01141599264707338, 0.01141599264707338, 0.019474007352926037, 0.019474007352926037, 0.005738749999977699, 0.01141599264707338, 0.003764797794133301, 0.00995090073524807, 0.00995090073524807, 0.008852058823549669, 0.00976775735296087, 0.008852077205858677, 0.009584632352925837, 0.009767757352904027, -0.0036012316176083914, 0.008852077205858677, 0.009767757352904027, 0.009584613970616829, 0.009584613970616829, 0.008852077205858677, 0.008852077205858677, 0.009950900735304913, 0.00885207720591552, 0.009767757352904027, 0.002116562500020791, 0.004497334558834609, 0.0021165441176549393, 0.0019334191176199056, 0.005921893382378585, 0.002116562500020791, 0.008852077205858677}, {0.010907132352940607, 0.0200639705882395, 0.012921636029432193, 0.011456544117663725, 0.008892628676505865, 0.012921636029432193, 0.011456544117606882, 0.014020459558821585, 0.011456544117663725, 0.011456544117663725, 0.01951455882351638, 0.01951454044115053, 0.005779301470624887, 0.011456525735297873, 0.0038053308823577936, 0.009991433823529405, 0.009991433823529405, 0.00889261029408317, 0.009808308823494372, 0.00889261029408317, 0.00962516544115033, 0.009808308823494372, -0.0035606801470748906, 0.008892628676505865, 0.009808290441185363, 0.009625165441207173, 0.009625165441207173, 0.008892628676449021, 0.008892628676505865, 0.009991433823529405, 0.00889261029408317, 0.009808308823551215, 0.0021570955882452836, 0.0045378860294249534, 0.0021571139706111353, 0.0019739705882670933, 0.005962426470603077, 0.0021570955882452836, 0.00889261029408317}, {0.012453658088247721, 0.021610477941123918, 0.014468143382373455, 0.013003051470604987, 0.010439136029390284, 0.014468161764739307, 0.013003069852913995, 0.015566985294071856, 0.013003069852970839, 0.013003069852913995, 0.021061066176514487, 0.021061084558823495, 0.007325808823566149, 0.013003051470604987, 0.010439154411756135, 0.01662523897061874, 0.01662523897061874, 0.015526433823538355, 0.011354834558858329, 0.010439154411756135, 0.011171691176514287, 0.011354834558801485, 0.008159852941219015, 0.010439154411756135, 0.011354834558801485, 0.011171691176457443, 0.011171709558823295, 0.015526433823538355, 0.010439154411756135, 0.016625257352927747, 0.010439136029390284, 0.011354834558801485, 0.008790919117643625, 0.011171691176457443, 0.003703621323495554, 0.003520477941151512, 0.0024216727941279714, 0.003703621323495554, 0.010439136029390284}, {0.013471047794098467, 0.02262788602939736, 0.015485551470590053, 0.014020459558821585, 0.011456544117606882, 0.015485551470590053, 0.014020459558821585, 0.016584374999979445, 0.014020459558821585, 0.014020459558821585, 0.02207847426467424, 0.022078455882365233, 0.008343216911725904, 0.014020441176512577, 0.01145652573524103, 0.017642628676469485, 0.017642628676469485, 0.0165438235293891, 0.012372224264709075, 0.011456525735297873, 0.01218908088230819, 0.012372205882343223, 0.009177242647069761, 0.011456544117663725, 0.012372224264709075, 0.012189080882365033, 0.012189080882365033, 0.01654380514702325, 0.011456525735297873, 0.017642647058835337, 0.011456525735297873, 0.012372224264709075, 0.009808308823551215, 0.01218908088230819, 0.004721011029403144, 0.004537867647059102, 0.003439062499978718, 0.004721011029403144, 0.011456544117663725}, {0.007284926470617847, 0.016441764705859896, 0.009299448529418441, 0.007834338235284122, 0.005270422794126262, 0.00929943014705259, 0.007834338235284122, 0.010398253676498825, 0.007834338235284122, 0.007834338235340965, 0.01589235294119362, 0.015892352941136778, 0.0021570955882452836, 0.007834338235284122, 0.005270422794126262, 0.006369246323572497, 0.006369246323515654, 0.005270422794069418, 0.006186102941171612, 0.005270422794126262, 0.00600295955882757, 0.0061861213235374635, -0.007182867647031799, 0.005270422794126262, 0.006186102941171612, 0.00600295955882757, 0.00600295955882757, 0.005270422794126262, 0.005270422794126262, 0.006369246323515654, 0.005270422794126262, 0.006186102941171612, 0.003622187499956908, 0.006002977941193421, 0.0036221875000137516, 0.0034390625000355612, 0.0023402389705893256, 0.0036222058823796033, 0.005270441176492113}, {0.012209411764672495, 0.02136625000002823, 0.014223933823529933, 0.012758823529395613, 0.010194926470603605, 0.014223915441164081, 0.012758841911818308, 0.015322738970610317, 0.012758841911761465, 0.012758823529395613, 0.020816838235305113, 0.020816838235305113, 0.0070815808822999315, 0.012758841911761465, 0.010194908088237753, 0.011293749999992997, 0.011293731617627145, 0.010194908088237753, 0.011110606617648955, 0.010194908088237753, 0.010927463235304913, 0.011110588235283103, -0.0022583823529203073, 0.010194926470603605, 0.011110606617648955, 0.010927463235304913, 0.01092746323524807, 0.010194926470603605, 0.010194908088237753, 0.011293749999992997, 0.010194926470546761, 0.011110606617648955, 0.008546672794125243, 0.010927463235304913, 0.008546691176434251, 0.008363566176456061, 0.007264724264700817, 0.008546691176434251, 0.010194926470603605}, {0.013450569852921035, 0.022607408088219927, 0.015465055147103612, 0.013999963235278301, 0.01143604779412044, 0.01546507352941262, 0.013999963235278301, 0.01656387867643616, 0.013999963235335144, 0.013999963235278301, 0.022057996323553652, 0.0220579779411878, 0.008322720588239463, 0.013999963235278301, 0.01143604779412044, 0.012534871323566676, 0.012534871323509833, 0.01143604779412044, 0.012351727941165791, 0.01143604779412044, 0.012168584558821749, 0.012351746323531643, -0.0010172426470376195, 0.01143604779412044, 0.012351746323531643, 0.012168584558821749, 0.012168602941130757, 0.011436066176486293, 0.011436066176486293, 0.012534871323566676, 0.01143604779412044, 0.012351746323531643, 0.00978781250000793, 0.0121686029411876, 0.009787830882373783, 0.009604687499972897, 0.008505863970640348, 0.00978781250000793, 0.01143604779412044}, {0.01756102941175186, 0.026717886029416604, 0.019575533088243446, 0.01811044117647498, 0.015546525735260275, 0.019575533088243446, 0.01811045955884083, 0.020674356617689682, 0.01811044117647498, 0.01811044117647498, 0.026168455882327635, 0.026168455882327635, 0.01243319852943614, 0.01811044117647498, 0.015546525735260275, 0.01664534926470651, 0.01664534926470651, 0.015546525735260275, 0.01646222426472832, 0.015546525735317118, 0.016279080882327435, 0.016462205882305625, 0.0030932352941022145, 0.015546525735317118, 0.01646222426472832, 0.016279062500018426, 0.016279080882327435, 0.015546525735260275, 0.015546525735260275, 0.01664534926470651, 0.015546525735260275, 0.01646220588236247, 0.013898290441204608, 0.016279062500018426, 0.013898308823513617, 0.008627867647078347, 0.012616341911780182, 0.008811011029422389, 0.015546525735260275}, {0.01090713235299745, 0.0200639705882395, 0.01292163602937535, 0.011456544117663725, 0.008892628676505865, 0.012921636029432193, 0.011456544117663725, 0.014020459558821585, 0.011456544117606882, 0.011456544117663725, 0.01951455882351638, 0.019514540441207373, 0.0057793014705680434, 0.011456525735297873, 0.008892610294140013, 0.009991452205895257, 0.009991433823529405, 0.008892610294140013, 0.009808290441185363, 0.008892628676505865, 0.009625165441207173, 0.009808308823551215, -0.0035606801470748906, 0.008892628676449021, 0.009808290441185363, 0.009625165441207173, 0.009625165441207173, 0.008892628676449021, 0.008892628676449021, 0.009991452205895257, 0.008892610294140013, 0.009808308823494372, 0.007244393382336511, 0.009625165441207173, 0.007244393382336511, 0.00197397058821025, 0.005962426470603077, 0.007244393382336511, 0.008892628676449021}, {0.010764871323544867, 0.019921709558786915, 0.01277939338234546, 0.011314283088267985, 0.00875038602936229, 0.012779374999979609, 0.011314301470576993, 0.013878198529425845, 0.011314283088267985, 0.011314283088211141, 0.01937229779412064, 0.01937229779412064, 0.005637040441172303, 0.0011399816176549393, 0.008750367647053281, 0.004761911764717297, 0.009849191176442673, 0.0036630882352710614, 0.009666047794098631, 0.008750367647053281, 0.00948292279412044, 0.009666047794155475, -0.003702941176470631, 0.008750367647053281, 0.009666066176464483, 0.00948292279412044, 0.009482904411754589, 0.003663069852962053, 0.008750367647053281, 0.009849191176499517, 0.008750367647053281, 0.009666066176464483, 0.007102132352940771, 0.00948292279412044, 0.007102150735249779, 0.006919007352962581, 0.005820183823573188, 0.007102132352940771, 0.008750367647053281}, {0.010662996323503648, 0.019819834558859384, 0.012677499999995234, 0.011212408088226766, 0.008648492647068906, 0.012677499999995234, 0.011212408088226766, 0.01377632352944147, 0.011212408088226766, 0.011212408088226766, 0.019270422794079423, 0.019270441176445274, 0.005535165441187928, 0.006125110294078695, 0.008648492647068906, 0.004660036764676079, 0.009747316176458298, 0.003561194852920835, 0.009564172794114256, 0.008648492647068906, 0.009381047794079223, 0.009564172794114256, -0.0038048161765118493, 0.008648492647068906, 0.009564191176480108, 0.009381047794136066, 0.009381047794079223, 0.003561194852920835, 0.008648492647068906, 0.009747297794092447, 0.008648492647068906, 0.009564172794114256, 0.007000257352956396, 0.009381047794136066, 0.007000257352899553, 0.006817132352921362, 0.005718290441166118, 0.007000275735322248, 0.008648492647068906}, {0.009299779411719555, 0.01845661764707529, 0.011314301470576993, 0.009849191176499517, 0.007285275735284813, 0.011314283088211141, 0.009849191176499517, 0.012413106617657377, 0.009849191176442673, 0.009849191176442673, 0.017907205882352173, 0.017907205882352173, 0.004171948529403835, 0.009849191176499517, 0.007285275735284813, 0.008384099264674205, 0.008384099264674205, 0.007285275735341656, 0.008200955882387007, 0.007285275735284813, 0.008017830882351973, 0.008200974264696015, -0.005168014705873247, 0.007285275735284813, 0.008200955882387007, 0.008017812499986121, 0.008017812499986121, 0.007285275735341656, 0.007285275735284813, 0.008384099264731049, 0.007285275735284813, 0.008200974264696015, 0.005637058823538155, 0.008017812499986121, 0.005637058823538155, 0.005453915441194113, 0.0043550919118047204, 0.005637040441172303, 0.007285275735284813}, {0.010764871323544867, 0.01992170955884376, 0.012779393382402304, 0.011314283088211141, 0.008750386029419133, 0.012779374999979609, 0.011314301470633836, 0.013878198529369001, 0.011314283088211141, 0.011314283088267985, 0.0041107169117822195, 0.004110716911725376, 0.005637058823538155, 0.006227003676485765, 0.008750367647053281, 0.009849191176499517, 0.009849191176499517, 0.003663088235327905, 0.009666066176521326, 0.008750367647053281, 0.00948292279412044, 0.009666066176464483, -0.0037029227941616227, 0.008750367647053281, 0.009666047794098631, 0.009482904411754589, 0.00948292279412044, 0.0036630882352710614, 0.008750367647053281, 0.009849191176442673, 0.008750367647053281, 0.009666047794155475, 0.007102132352940771, 0.00948292279412044, 0.007102150735249779, 0.006919007352962581, 0.005820183823573188, 0.007102132352940771, 0.008750367647053281}, {0.01509882352945624, 0.02425566176469829, 0.017113327205890982, 0.015648235294122514, 0.013084301470598803, 0.017113327205890982, 0.015648235294122514, 0.018212132352914523, 0.015648235294122514, 0.015648235294122514, 0.02370624999997517, 0.023706250000032014, 0.009970992647083676, 0.015648235294122514, 0.01308431985290781, 0.014183143382354046, 0.014183125000045038, 0.013084319852964654, 0.014000000000010004, 0.01308431985290781, 0.013816856617609119, 0.014000018382319013, 6.310110294407423E-4, 0.01308431985290781, 0.013999999999953161, 0.013816875000031814, 0.013816856617665962, 0.013084319852964654, 0.013084319852964654, 0.014183143382354046, 0.013084319852964654, 0.014000000000010004, 0.011436084558852144, 0.013816856617609119, 0.0114360845587953, 0.01125295955881711, 0.010154136029370875, 0.0114360845587953, 0.01308431985290781}};
    private static final double[] BASELINES = new double[]{-0.004029007352941177, 0.0, 0.0, -0.004029007352941177, 0.0, -0.004029007352941177, -0.004029007352941177, -0.004029007352941177, -0.004029007352941177, -0.004029007352941177, 0.0, -0.0353454044117647, 0.03424658088235294, -0.002014503676470575, -0.002014503676470575, -0.002014503676470575, -0.002014503676470575, -0.0020145036764705818, 0.0, -0.03772617647058826, 0.0, 0.0, -0.037543033088235284, 0.0, 0.0, 0.0, 0.0, -0.002014503676470575, -0.03552852941176471, -0.03552852941176471, 0.0, -0.002014503676470575, -0.0020145036764705818, -0.002014503676470575, -0.002014503676470575, -0.002014503676470575, 0.0, -0.037543033088235284, 0.0};
    private static final LaTeXMathObject glyphs = LaTeXMathObject.make("0123456789.,-abcdefghijklmnopqrstuvwxyz");

    public static JMNumber length(Point A, Point B) {
        return new JMNumberLength(A, B);
    }

    public static JMNumber makeJMnumber(double number) {
        JMNumber resul = new JMNumber(0.0);
        resul.setNumber(number);
        resul.style("latexdefault");
        return resul;
    }

    protected JMNumber(double number) {
        this.number = number;
        this.modelMatrix = new AffineJTransform();
        this.formatter = new DecimalFormat("#.##");
    }

    public JMNumber applyAffineTransform(AffineJTransform transform) {
        super.applyAffineTransform(transform);
        AffineJTransform compose = this.modelMatrix.compose(transform);
        this.modelMatrix.copyFrom(compose);
        this.updateContents();
        return this;
    }

    private void updateContents() {
        String text = this.formatter.format(this.getNumber());
        for (Shape sh : this.shapes) {
            this.scene.remove(sh);
        }
        this.shapes.clear();
        Shape previous = null;
        int indexPrevious = -1;
        String finalChars = "";
        for (char c : text.toCharArray()) {
            int index = SYMBOLS.indexOf(c);
            if (index != -1) {
                Shape shapeToAdd = glyphs.get(index).copy();
                if (previous != null) {
                    shapeToAdd.stackTo(previous, Anchor.Type.RIGHT, GAPS[indexPrevious][index]);
                } else {
                    shapeToAdd.center();
                }
                previous = shapeToAdd;
                indexPrevious = index;
                this.add(shapeToAdd);
                finalChars = finalChars + String.valueOf(c);
                continue;
            }
            JMathAnimScene.logger.warn("Symbol " + String.valueOf(c) + " not found in table");
        }
        for (int n = 0; n < this.shapes.size(); ++n) {
            Shape sh = (Shape)this.shapes.get(n);
            sh.align(Point.origin(), MathObject.Align.LOWER);
            char c = finalChars.toCharArray()[n];
            int index = SYMBOLS.indexOf(c);
            sh.shift(0.0, BASELINES[index]);
        }
        for (Shape sh : this.shapes) {
            sh.getMp().copyFrom(this.mpMultiShape);
            sh.applyAffineTransform(this.modelMatrix);
        }
    }

    public double getNumber() {
        return this.number;
    }

    public final void setNumber(double number) {
        this.number = number;
        this.updateContents();
    }

    public <T extends JMNumber> T setFormat(String format) {
        this.formatter.applyPattern(format);
        this.updateContents();
        return (T)this;
    }

    @Override
    public void saveState() {
        this.modelMatrix.saveState();
        super.saveState();
    }

    @Override
    public void restoreState() {
        this.modelMatrix.restoreState();
        super.restoreState();
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof JMNumber)) {
            return;
        }
        JMNumber n = (JMNumber)obj;
        this.modelMatrix.copyFrom(n.modelMatrix);
        super.copyStateFrom(obj);
        this.updateContents();
    }

    private static void printArrayOfGaps() {
        String gapString = "{";
        for (char c1 : SYMBOLS.toCharArray()) {
            String combine = "";
            for (char c2 : SYMBOLS.toCharArray()) {
                combine = combine + String.valueOf(c1) + String.valueOf(c2);
            }
            LaTeXMathObject texto = LaTeXMathObject.make(combine);
            gapString = gapString + "{";
            boolean addComma = false;
            for (int n = 0; n < texto.size() - 1; n += 2) {
                Shape s = texto.get(n);
                Shape s2 = texto.get(n + 1);
                double hor = s2.getBoundingBox().xmin - s.getBoundingBox().xmax;
                gapString = gapString + (addComma ? ", " : "") + hor;
                addComma = true;
            }
            gapString = gapString + "},\n";
        }
        gapString = gapString.substring(0, gapString.length() - 2) + "}";
        System.out.println(gapString);
    }

    private static void creaBaseLines() {
        String baselineString = "{";
        LaTeXMathObject texto = LaTeXMathObject.make(SYMBOLS);
        double base = texto.get((int)1).getBoundingBox().ymin;
        boolean addComma = false;
        for (Shape sh : texto) {
            baselineString = baselineString + (addComma ? "," : "") + (sh.getBoundingBox().ymin - base);
            addComma = true;
        }
        baselineString = baselineString + "}";
        System.out.println(baselineString);
    }

    @Override
    public JMNumber copy() {
        JMNumber copy = JMNumber.makeJMnumber(this.getNumber());
        copy.getMp().copyFrom(this.getMp());
        copy.setFormat(this.formatter.toPattern());
        copy.modelMatrix.copyFrom(this.modelMatrix);
        copy.updateContents();
        return copy;
    }

    public DecimalFormat getFormatter() {
        return this.formatter;
    }
}

