/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Text;

import com.jmathanim.Styling.JMColor;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.SVGUtils;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.SVGMathObject;
import com.jmathanim.mathobjects.Shape;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LaTeXMathObject
extends SVGMathObject {
    private String text;
    private File latexFile;
    private String baseFileName;
    private File outputDir;
    public static final double DEFAULT_SCALE_FACTOR = 0.05;

    public static LaTeXMathObject make(String text) {
        LaTeXMathObject t = new LaTeXMathObject();
        if (!"".equals(text)) {
            t.setLaTeX(text);
        }
        if (t.shapes.size() > 0) {
            t.center();
        }
        return t;
    }

    protected LaTeXMathObject() {
        this.getMp().loadFromStyle("latexdefault");
        this.getMp().setAbsoluteThickness(true);
        this.getMp().setFillColor(this.getMp().getDrawColor());
        this.getMp().setThickness(1.0);
    }

    public <T extends LaTeXMathObject> T setLaTeX(String text) {
        if (text.equals(this.text)) {
            return (T)this;
        }
        this.text = text;
        Point center = this.shapes.isEmpty() ? JMathAnimConfig.getConfig().getCamera().getMathView().getCenter() : this.getCenter();
        this.text = text;
        for (Shape sh : this.shapes) {
            this.scene.remove(sh);
        }
        this.shapes.clear();
        try {
            this.generateLaTeXDocument();
            File f = new File(this.compileLaTeXFile());
            SVGUtils svgu = new SVGUtils(this.scene);
            svgu.importSVG(f.toURI().toURL(), this);
        }
        catch (IOException ex) {
            if (ex.getLocalizedMessage().toUpperCase().startsWith("CANNOT RUN PROGRAM")) {
                JMathAnimScene.logger.error("Oops, it seems JMathAnim cannot find your LaTeX executable. Make sure you have LaTeX installed on your system and the latex program is accesible from your path");
            } else {
                JMathAnimScene.logger.error("An unknown I/O error. Maybe you don't have permissionsto write files on your working directory or there is not enough space on disk.");
            }
            JMathAnimScene.logger.warn("An empty LaTeXMathObject will be created");
        }
        catch (Exception ex) {
            JMathAnimScene.logger.error("An unknown  error happened trying to create a LaTeXMathObject");
            JMathAnimScene.logger.warn("An empty LaTeXMathObject will be created");
        }
        int n = 0;
        for (Shape sh : this.shapes) {
            sh.objectLabel = String.valueOf(n);
            ++n;
            if (!this.isAddedToScene) continue;
            this.scene.add(sh);
        }
        double hm = 2.5;
        double sc = 0.020000000000000004 * hm / 6.8 * 2.5;
        this.scale(this.getBoundingBox().getUL(), sc, sc, 1.0);
        this.moveTo(center);
        return (T)this;
    }

    private void generateLaTeXDocument() throws IOException {
        String beginDocument = "\\documentclass[preview]{standalone}\n\\usepackage{xcolor}\n\\usepackage{amssymb}\\usepackage{amsmath}\\begin{document}\n";
        String endDocument = "\\end{document}";
        String fullDocument = beginDocument + this.text + "\n" + endDocument;
        String hash = this.getMd5(fullDocument);
        hash = hash.substring(hash.length() - 8);
        this.outputDir = new File("tex");
        this.baseFileName = this.outputDir.getCanonicalPath() + File.separator + hash;
        this.latexFile = new File(this.baseFileName + ".tex");
        this.outputDir.mkdirs();
        try {
            FileWriter fw = new FileWriter(this.latexFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.print(fullDocument);
            pw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(LaTeXMathObject.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getMd5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger bi = new BigInteger(1, messageDigest);
            String hash = bi.toString(16);
            while (hash.length() < 32) {
                hash = "0" + hash;
            }
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String compileLaTeXFile() throws IOException, InterruptedException {
        String svgFilename = this.baseFileName + ".svg";
        File svgFile = new File(svgFilename);
        if (!svgFile.exists()) {
            JMathAnimScene.logger.info("Compiling LaTeX string " + this.text);
            File dviFile = new File(this.baseFileName + ".dvi");
            String od = this.outputDir.getCanonicalPath();
            this.runExternalCommand("latex -output-directory=" + od + " " + this.latexFile.getCanonicalPath());
            JMathAnimScene.logger.debug("Done compiling {}", (Object)this.latexFile.getCanonicalPath());
            this.runExternalCommand("dvisvgm -n1 " + dviFile.getCanonicalPath());
            JMathAnimScene.logger.debug("Done converting {}", (Object)dviFile.getCanonicalPath());
        }
        return svgFilename;
    }

    public void runExternalCommand(String command) throws IOException, InterruptedException {
        String line;
        BufferedReader bre;
        Process p = Runtime.getRuntime().exec(command, null, this.outputDir);
        try (BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = bri.readLine()) != null) {
                JMathAnimScene.logger.debug(line);
            }
        }
        while ((line = bre.readLine()) != null) {
            JMathAnimScene.logger.debug(line);
        }
        bre.close();
        p.waitFor();
    }

    @Override
    public LaTeXMathObject copy() {
        LaTeXMathObject resul = new LaTeXMathObject();
        resul.getMp().copyFrom(this.getMp());
        for (Shape sh : this.shapes) {
            Shape copy = sh.copy();
            resul.add(copy);
        }
        resul.absoluteSize = this.absoluteSize;
        return resul;
    }

    @Override
    public int size() {
        return this.shapes.size();
    }

    public String getText() {
        return this.text;
    }

    public LaTeXMathObject setColor(String str) {
        return this.setColor(JMColor.parse(str));
    }

    public LaTeXMathObject setColor(JMColor col) {
        this.drawColor(col);
        this.fillColor(col);
        return this;
    }

    public LaTeXMathObject setColor(String str, int ... indices) {
        return this.setColor(JMColor.parse(str), indices);
    }

    public LaTeXMathObject setColor(JMColor col, int ... indices) {
        for (int i : indices) {
            this.get(i).drawColor(col);
            this.get(i).fillColor(col);
        }
        return this;
    }
}

