/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Tippable;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import com.jmathanim.mathobjects.Text.LaTeXMathObject;
import com.jmathanim.mathobjects.Tippable.TippableObject;

public class LabelTip
extends TippableObject {
    private LaTeXMathObject latexLabel;
    private Point markPoint;
    private boolean fixedAngle;
    private double textOffset;
    protected MathObjectGroup group;

    public static LabelTip makeLabelTip(Shape shape, double location, String text) {
        return LabelTip.makeLabelTip(shape, location, LaTeXMathObject.make(text));
    }

    public static LabelTip makeLabelTip(Shape shape, double location, LaTeXMathObject text) {
        LabelTip resul = new LabelTip();
        resul.shape = shape;
        resul.setLocation(location);
        resul.group = MathObjectGroup.make(new MathObject[0]);
        resul.latexLabel = text;
        resul.group.add((MathObject)resul.latexLabel);
        resul.markPoint = (Point)Point.at(0.0, 0.0).visible(false);
        resul.group.add((MathObject)resul.markPoint);
        resul.setTextOffset(0.5 * resul.latexLabel.getHeight());
        resul.setTip(resul.group);
        resul.setAnchor(Anchor.Type.LOWER);
        resul.setOffsetAngle(-1.5707963267948966);
        return resul;
    }

    public double getTextOffset() {
        return this.textOffset;
    }

    public <T extends LabelTip> T setTextOffset(double textOffset) {
        if (textOffset < 0.0) {
            textOffset = -textOffset;
        }
        this.textOffset = textOffset;
        this.group.setLayout(MathObjectGroup.Layout.LOWER, this.getTextOffset());
        return (T)this;
    }

    public <T extends LabelTip> T setTextOffsetRW(double textOffset) {
        return this.setTextOffset(textOffset * this.latexLabel.getWidth());
    }

    public <T extends LabelTip> T setTextOffsetRH(double textOffset) {
        return this.setTextOffset(textOffset * this.latexLabel.getHeight());
    }

    private LabelTip() {
    }

    @Override
    protected void updateLocations() {
        super.updateLocations();
        MathObjectGroup msh = (MathObjectGroup)this.getTipCopy();
        if (this.fixedAngle) {
            msh.get(0).rotate(-this.totalRotationAngle);
        }
    }

    public <T extends LabelTip> T fixedAngle(boolean fixedAngle) {
        this.fixedAngle = fixedAngle;
        return (T)this;
    }

    public Point getMarkPoint() {
        return this.markPoint;
    }

    public <T extends LabelTip> T visibleMarkPoint(boolean visible) {
        this.markPoint.visible(visible);
        return (T)this;
    }
}

