/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.Tippable;

import com.jmathanim.Renderers.Renderer;
import com.jmathanim.Styling.MODrawPropertiesArray;
import com.jmathanim.Styling.Stylable;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Arrow2D;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class TippableObject
extends MathObject {
    public static final double DELTA_DERIVATIVE = 1.0E-4;
    private Anchor.Type anchor;
    private slopeDirection direction;
    MODrawPropertiesArray mpArray = new MODrawPropertiesArray();
    private double offsetAngle = 0.0;
    private Point pointLoc;
    private Vec pointTo;
    private double scaleFactorX = 1.0;
    private double scaleFactorY = 1.0;
    protected Shape shape;
    private double tLocation;
    private MathObject tip;
    private MathObject tipCopy;
    protected double totalRotationAngle;

    public static TippableObject make(Shape shape, double location, slopeDirection direction, MathObject tip) {
        TippableObject resul = new TippableObject();
        resul.shape = shape;
        resul.setLocation(location);
        resul.setDirection(direction);
        resul.setTip(tip);
        return resul;
    }

    public static TippableObject equalLengthTip(Shape shape, double location, int numberOfMarks) {
        MultiShapeObject parallelSign = new MultiShapeObject();
        for (int i = 0; i < numberOfMarks; ++i) {
            parallelSign.add(Shape.segment(Point.at(0.0, i), Point.at(2.0, i)));
        }
        TippableObject resul = new TippableObject();
        resul.shape = shape;
        resul.setLocation(location);
        resul.setTip(parallelSign);
        resul.setWidth(0.05);
        resul.setAnchor(Anchor.Type.CENTER);
        resul.getTip().setAbsoluteSize();
        return resul;
    }

    public static TippableObject arrowHead(Shape shape, double location, slopeDirection direction, Arrow2D.ArrowType type) {
        MultiShapeObject arrowHead = Arrow2D.buildArrowHead(type);
        arrowHead.fillColor(shape.getMp().getDrawColor());
        arrowHead.drawColor(shape.getMp().getDrawColor());
        arrowHead.thickness(4.0);
        TippableObject resul = new TippableObject();
        resul.shape = shape;
        resul.setLocation(location);
        resul.setTip(arrowHead);
        resul.setWidth(0.05);
        resul.setAnchor(Anchor.Type.UPPER);
        resul.getTip().setAbsoluteSize();
        return resul;
    }

    public TippableObject() {
        this.anchor = Anchor.Type.UPPER;
    }

    @Override
    public <T extends MathObject> T copy() {
        TippableObject copy = TippableObject.make(this.shape, this.getLocation(), this.direction, this.getTip().copy());
        copy.copyStateFrom(this);
        return (T)this;
    }

    @Override
    public void copyStateFrom(MathObject obj) {
        if (!(obj instanceof TippableObject)) {
            return;
        }
        TippableObject t = (TippableObject)obj;
        this.shape.copyStateFrom(t.shape);
        this.pointLoc.copyStateFrom(t.pointLoc);
        this.pointTo.copyFrom(t.pointTo);
        this.totalRotationAngle = t.totalRotationAngle;
        this.anchor = t.anchor;
        this.direction = t.direction;
        this.getMp().copyFrom(t.getMp());
        this.offsetAngle = t.offsetAngle;
        this.scaleFactorX = t.scaleFactorX;
        this.scaleFactorY = t.scaleFactorY;
        this.tLocation = t.tLocation;
        this.tip.copyStateFrom(t.tip);
        this.totalRotationAngle = t.totalRotationAngle;
    }

    @Override
    public void draw(JMathAnimScene scene, Renderer r) {
        if (this.isVisible()) {
            this.getTipCopy().draw(scene, r);
            scene.markAsAlreadyDrawed(this);
        }
    }

    public Anchor.Type getAnchor() {
        return this.anchor;
    }

    public <T extends TippableObject> T setAnchor(Anchor.Type anchor) {
        this.anchor = anchor;
        return (T)this;
    }

    @Override
    public Rect getBoundingBox() {
        this.updateLocations();
        return this.getTipCopy().getBoundingBox();
    }

    public slopeDirection getDirection() {
        return this.direction;
    }

    public double getLocation() {
        return this.tLocation;
    }

    public final void setLocation(double location) {
        while (location > 1.0) {
            location -= 1.0;
        }
        while (location < 0.0) {
            location += 1.0;
        }
        this.tLocation = location;
    }

    @Override
    public Stylable getMp() {
        return this.mpArray;
    }

    public double getOffsetAngle() {
        return this.offsetAngle;
    }

    public MathObject getTip() {
        return this.tip;
    }

    public final <T extends TippableObject> T setTip(MathObject tip) {
        this.mpArray.remove(this.tip);
        this.tip = tip;
        this.mpArray.add(tip);
        return (T)this;
    }

    protected MathObject getTipCopy() {
        return this.tipCopy;
    }

    protected void setTipCopy(MathObject tipCopy) {
        this.tipCopy = tipCopy;
    }

    public MathObject getTippedObject() {
        this.update(this.scene);
        return this.getTipCopy();
    }

    @Override
    public int getUpdateLevel() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.tip.restoreState();
    }

    @Override
    public <T extends MathObject> T rotate(double angle) {
        this.tip.rotate(angle);
        return (T)this;
    }

    @Override
    public void saveState() {
        super.saveState();
        this.tip.saveState();
    }

    @Override
    public <T extends MathObject> T scale(double sx, double sy) {
        this.scaleFactorX *= sx;
        this.scaleFactorY *= sy;
        return (T)this;
    }

    @Override
    public <T extends MathObject> T scale(double s) {
        return this.scale(s, s);
    }

    public final <T extends MathObject> T setDirection(slopeDirection direction) {
        this.direction = direction;
        return (T)this;
    }

    @Override
    public <T extends MathObject> T setHeight(double h) {
        this.tip.setHeight(h);
        return (T)this;
    }

    public <T extends TippableObject> T setOffsetAngle(double angle) {
        this.offsetAngle = angle;
        return (T)this;
    }

    @Override
    public <T extends MathObject> T setWidth(double w) {
        this.tip.setWidth(w);
        return (T)this;
    }

    @Override
    public void update(JMathAnimScene scene) {
        this.updateLocations();
    }

    protected void updateLocations() {
        this.pointLoc = this.shape.getPath().getJMPointAt((double)this.getLocation()).p;
        this.setTipCopy((MathObject)this.getTip().copy());
        this.getTipCopy().scale(this.scaleFactorX, this.scaleFactorY);
        Point headPoint = Anchor.getAnchorPoint(this.getTipCopy(), this.anchor);
        this.getTipCopy().shift(headPoint.to(this.pointLoc));
        Point slopeTo = this.direction == slopeDirection.NEGATIVE ? this.shape.getPath().getJMPointAt((double)(this.getLocation() - 1.0E-4)).p : this.shape.getPath().getJMPointAt((double)(this.getLocation() + 1.0E-4)).p;
        this.pointTo = this.pointLoc.to(slopeTo);
        double rotAngle = this.pointTo.getAngle();
        this.totalRotationAngle = -1.5707963267948966 + rotAngle + this.getOffsetAngle();
        this.getTipCopy().rotate(this.pointLoc, this.totalRotationAngle);
    }

    public static enum slopeDirection {
        NEGATIVE,
        POSITIVE;

    }
}

