/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.updateableObjects;

import com.jmathanim.Utils.Anchor;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.updateableObjects.Updateable;

public class AnchoredMathObject
implements Updateable {
    private final MathObject mobj;
    private final MathObject dstObject;
    private Anchor.Type dstType;
    private Anchor.Type origType;
    private double gap;

    public AnchoredMathObject(MathObject mobj, Anchor.Type origType, MathObject dstObject, Anchor.Type dstType) {
        this(mobj, origType, dstObject, dstType, 0.0);
    }

    public AnchoredMathObject(MathObject mobj, Anchor.Type origType, MathObject dstObject, Anchor.Type dstType, double gap) {
        this.mobj = mobj;
        this.dstObject = dstObject;
        this.origType = origType;
        this.dstType = dstType;
        this.gap = gap;
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double gap) {
        this.gap = gap;
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(this.mobj.getUpdateLevel(), this.dstObject.getUpdateLevel()) + 1;
    }

    @Override
    public void update(JMathAnimScene scene) {
        this.mobj.stackTo(this.origType, this.dstObject, this.dstType, this.gap);
    }

    public Anchor.Type getAnchorType() {
        return this.dstType;
    }

    public void setAnchorType(Anchor.Type anchorType) {
        this.dstType = anchorType;
    }
}

