/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.updateableObjects;

import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.Shape;

public class BooleanShape
extends Shape {
    private final Operation operation;
    Shape shape1;
    Shape shape2;

    public BooleanShape(Operation operation, Shape shape1, Shape shape2) {
        this.shape1 = shape1;
        this.shape2 = shape2;
        this.operation = operation;
    }

    @Override
    public void update(JMathAnimScene scene) {
        JMPath newPath = null;
        switch (this.operation) {
            case UNION: {
                newPath = this.shape1.getUnionPath(this.shape2);
                break;
            }
            case INTERSECTION: {
                newPath = this.shape1.getIntersectionPath(this.shape2);
                break;
            }
            case SUBSTRACTION: {
                newPath = this.shape1.getSubstractPath(this.shape2);
            }
        }
        this.getPath().clear();
        this.getPath().addJMPointsFrom(newPath);
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(this.shape1.getUpdateLevel(), this.shape2.getUpdateLevel()) + 1;
    }

    public static enum Operation {
        UNION,
        INTERSECTION,
        SUBSTRACTION;

    }
}

