/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.updateableObjects;

import com.jmathanim.Cameras.Camera;
import com.jmathanim.Utils.Rect;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.updateableObjects.Updateable;

public class CameraAlwaysAdjusting
implements Updateable {
    Camera camera;
    double hgap;
    double vgap;

    public CameraAlwaysAdjusting(Camera cam, double hgap, double vgap) {
        this.camera = cam;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    @Override
    public int getUpdateLevel() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void update(JMathAnimScene scene) {
        if (!scene.getObjects().isEmpty()) {
            Rect bbox = this.camera.getMathView().addGap(-this.hgap, -this.vgap);
            for (MathObject obj : scene.getObjects()) {
                bbox = Rect.union(bbox, obj.getBoundingBox());
            }
            this.camera.adjustToRect(bbox.addGap(this.hgap, this.vgap));
        }
    }
}

