/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.updateableObjects;

import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import com.jmathanim.mathobjects.updateableObjects.Updateable;

public class Centroid
extends Point
implements Updateable {
    private final Shape shape;

    public Centroid(Shape shape) {
        this.shape = shape;
    }

    @Override
    public void update(JMathAnimScene scene) {
        Vec resul = new Vec(0.0, 0.0);
        for (int n = 0; n < this.shape.size(); ++n) {
            resul.addInSite(this.shape.get((int)n).p.v);
        }
        resul.multInSite(1.0 / (double)this.shape.size());
        this.v.copyFrom(resul);
    }

    @Override
    public int getUpdateLevel() {
        int level = -1;
        for (JMPathPoint p : this.shape.getPath()) {
            level = Math.max(level, p.getUpdateLevel());
        }
        return level;
    }
}

