/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.updateableObjects;

import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.FunctionGraph;
import com.jmathanim.mathobjects.Point;

public class PointOnFunctionGraph
extends Point {
    FunctionGraph fg;
    private final Point slopePointRight;
    private final Point slopePointLeft;

    public PointOnFunctionGraph(double x, FunctionGraph fg) {
        this.fg = fg;
        this.slopePointRight = Point.at(x, 0.0);
        this.slopePointLeft = Point.at(x, 0.0);
        this.v.x = x;
        this.computePoints();
    }

    @Override
    public int getUpdateLevel() {
        return this.fg.getUpdateLevel() + 1;
    }

    @Override
    public void update(JMathAnimScene scene) {
        this.computePoints();
    }

    private void computePoints() {
        this.v.y = this.fg.function.applyAsDouble(this.v.x);
        this.slopePointRight.v.x = this.v.x + 1.0;
        this.slopePointRight.v.y = this.v.y + this.fg.getSlope(this.v.x, -1);
        this.slopePointLeft.v.x = this.v.x - 1.0;
        this.slopePointLeft.v.y = this.v.y - this.fg.getSlope(this.v.x, -1);
    }

    public FunctionGraph getFg() {
        return this.fg;
    }

    public Point getSlopePointRight() {
        return this.slopePointRight;
    }

    public Point getSlopePointLeft() {
        return this.slopePointLeft;
    }
}

