/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.mathobjects.updateableObjects;

import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Shape;

public class Trail
extends Shape {
    MathObject marker;
    private boolean cutNext = true;
    private boolean draw = true;

    public static Trail make(MathObject marker) {
        return new Trail(marker);
    }

    public Trail(MathObject marker) {
        this.marker = marker;
        this.getPath().addPoint(marker.getCenter());
        this.get((int)0).isThisSegmentVisible = false;
    }

    @Override
    public void update(JMathAnimScene scene) {
        if (this.draw) {
            JMPathPoint pa = JMPathPoint.lineTo(this.marker.getCenter());
            pa.isThisSegmentVisible = !this.cutNext;
            this.cutNext = false;
            this.getPath().addJMPoint(pa);
        }
    }

    @Override
    public int getUpdateLevel() {
        return Math.max(super.getUpdateLevel(), this.marker.getUpdateLevel()) + 1;
    }

    public void raisePen() {
        this.draw = false;
    }

    public void lowerPen() {
        this.draw = true;
        this.cutNext = true;
    }
}

