/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.beans;

import com.fluentinterface.beans.PropertyNotFoundException;
import com.fluentinterface.beans.reflect.Bean;
import com.fluentinterface.beans.reflect.Property;
import com.fluentinterface.beans.reflect.ReflectionException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectWrapper {
    private Bean<?> bean;
    private Object object;
    private boolean isAutoGrowing = true;
    private boolean isAutoInstancing = true;
    private boolean isOutOfBoundsSafety = true;

    public ObjectWrapper(Object obj) {
        this.setWrappedObject(obj);
    }

    public void setWrappedObject(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Cannot warp a 'null' object.");
        }
        this.object = obj;
        this.bean = Bean.forClass(obj.getClass());
    }

    public Bean<?> getBean() {
        return this.bean;
    }

    public void setAutoGrowing(boolean isAutoGrowing) {
        this.isAutoGrowing = isAutoGrowing;
    }

    public void setAutoInstancing(boolean isAutoInstancing) {
        this.isAutoInstancing = isAutoInstancing;
    }

    public void setOutOfBoundsSafety(boolean isOutOfBoundsSafety) {
        this.isOutOfBoundsSafety = isOutOfBoundsSafety;
    }

    public Property getProperty(String propertyPattern) {
        return ObjectWrapper.getProperty(this.bean, propertyPattern);
    }

    public Object getValue(String propertyPattern) {
        return ObjectWrapper.getValue(this.object, propertyPattern, this);
    }

    public Object getSimpleValue(String propertyName) {
        return ObjectWrapper.getSimpleValue(this.object, ObjectWrapper.getPropertyOrThrow(this.bean, propertyName));
    }

    public Object getSimpleValue(Property property) {
        return ObjectWrapper.getSimpleValue(this.object, property);
    }

    public Object getIndexedValue(String propertyName, int index) {
        return ObjectWrapper.getIndexedValue(this.object, ObjectWrapper.getPropertyOrThrow(this.bean, propertyName), index, this);
    }

    public Object getIndexedValue(Property property, int index) {
        return ObjectWrapper.getIndexedValue(this.object, property, index, this);
    }

    public Object getMappedValue(String propertyName, Object key) {
        return ObjectWrapper.getMappedValue(this.object, ObjectWrapper.getPropertyOrThrow(this.bean, propertyName), key);
    }

    public Object getMappedValue(Property property, Object key) {
        return ObjectWrapper.getMappedValue(this.object, property, key);
    }

    public void setValue(String propertyPattern, Object value) {
        ObjectWrapper.setValue(this.object, propertyPattern, value, this);
    }

    public void setSimpleValue(String propertyName, Object value) {
        ObjectWrapper.setSimpleValue(this.object, ObjectWrapper.getPropertyOrThrow(this.bean, propertyName), value);
    }

    public void setSimpleValue(Property property, Object value) {
        ObjectWrapper.setSimpleValue(this.object, property, value);
    }

    public void setIndexedValue(String propertyName, int index, Object value) {
        ObjectWrapper.setIndexedValue(this.object, ObjectWrapper.getPropertyOrThrow(this.bean, propertyName), index, value, this);
    }

    public void setIndexedValue(Property property, int index, Object value) {
        ObjectWrapper.setIndexedValue(this.object, property, index, value, this);
    }

    public void setMappedValue(String propertyName, Object key, Object value) {
        ObjectWrapper.setMappedValue(this.object, ObjectWrapper.getPropertyOrThrow(this.bean, propertyName), key, value, this);
    }

    public void setMappedValue(Property property, Object key, Object value) {
        ObjectWrapper.setMappedValue(this.object, property, key, value, this);
    }

    public String toString() {
        return "ObjectWrapper{object=" + this.object + '}';
    }

    private static Property getPropertyOrThrow(Bean bean, String propertyName) {
        Property property = bean.getProperty(propertyName);
        if (property == null) {
            throw new PropertyNotFoundException("Cannot find property with name '" + propertyName + "' in " + bean + ".");
        }
        return property;
    }

    private static int indexOfDotOrSquare(String propertyPattern) {
        int lenght = propertyPattern.length();
        int result = 0;
        boolean dotFound = false;
        boolean insideSquares = false;
        for (int i = 0; !dotFound && i < lenght; ++i) {
            char current = propertyPattern.charAt(i);
            if (!insideSquares) {
                if (current == '.') {
                    dotFound = true;
                    result = i;
                    continue;
                }
                if (current != '[') continue;
                insideSquares = true;
                result = -i;
                continue;
            }
            if (current != ']') continue;
            insideSquares = false;
        }
        if (insideSquares) {
            throw new IllegalArgumentException("Cannot found the closing ']' suffix in '" + propertyPattern + "' pattern.");
        }
        return result;
    }

    public static Property getProperty(Bean bean, String propertyPattern) {
        if (propertyPattern == null) {
            throw new IllegalArgumentException("Cannot get a property with a 'null' propertyPattern.");
        }
        int position = ObjectWrapper.indexOfDotOrSquare(propertyPattern);
        if (position > 0) {
            String leftPattern = propertyPattern.substring(0, position);
            String rightPattern = propertyPattern.substring(position + 1, propertyPattern.length());
            Property leftProperty = bean.getProperty(leftPattern);
            return leftProperty != null ? ObjectWrapper.getProperty(Bean.forClass(leftProperty.getType()), rightPattern) : null;
        }
        if (position < 0) {
            throw new IllegalArgumentException("The indexed or mapped '[]' notation is not allowed while searching a property, but '" + propertyPattern + "' pattern found.");
        }
        return bean.getProperty(propertyPattern);
    }

    private static Object getValue(Object obj, String propertyPattern, ObjectWrapper options) {
        if (propertyPattern == null) {
            throw new IllegalArgumentException("Cannot get the value from a property with a 'null' propertyPattern.");
        }
        if (obj == null) {
            throw new NullPointerException("Cannot get the value of '" + propertyPattern + "' from a 'null' object.");
        }
        int position = ObjectWrapper.indexOfDotOrSquare(propertyPattern);
        if (position > 0) {
            String leftPattern = propertyPattern.substring(0, position);
            String rightPattern = propertyPattern.substring(position + 1, propertyPattern.length());
            Object leftValue = ObjectWrapper.getValue(obj, leftPattern, options);
            return ObjectWrapper.getValue(leftValue, rightPattern, options);
        }
        if (position < 0) {
            int squarePosition = -position;
            String leftPattern = propertyPattern.substring(0, squarePosition);
            String indexOrKey = propertyPattern.substring(squarePosition + 1, propertyPattern.length() - 1);
            Property leftProperty = ObjectWrapper.getPropertyOrThrow(Bean.forClass(obj.getClass()), leftPattern);
            if (Map.class.isAssignableFrom(leftProperty.getType())) {
                return ObjectWrapper.getMappedValue(obj, leftProperty, indexOrKey);
            }
            try {
                return ObjectWrapper.getIndexedValue(obj, leftProperty, Integer.parseInt(indexOrKey), options);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The pattern '" + indexOrKey + "' for the indexed " + leftProperty + " is invalid. Cannot parse the string to a valid integer index.");
            }
        }
        return ObjectWrapper.getSimpleValue(obj, ObjectWrapper.getPropertyOrThrow(Bean.forClass(obj.getClass()), propertyPattern));
    }

    private static Object getSimpleValue(Object obj, Property property) {
        if (property == null) {
            throw new IllegalArgumentException("Cannot get the value from a 'null' property.");
        }
        return property.get(obj);
    }

    private static Object getIndexedValue(Object obj, Property property, int index, ObjectWrapper options) {
        if (property == null) {
            throw new IllegalArgumentException("Cannot get the indexed value from 'null' property.");
        }
        Object propertyValue = property.get(obj);
        if (propertyValue == null) {
            throw new NullPointerException("Invalid 'null' value found for indexed '" + property + "' in " + obj.getClass().getName() + ".");
        }
        if (propertyValue instanceof List) {
            List list = (List)propertyValue;
            int size = list.size();
            if (size < index) {
                if (options.isOutOfBoundsSafety) {
                    return null;
                }
                throw new IndexOutOfBoundsException("The indexed " + property + " in " + obj.getClass().getSimpleName() + " object has only '" + size + "' elements, but index '" + index + "' requested.");
            }
            return list.get(index);
        }
        if (propertyValue.getClass().isArray()) {
            int lenght = Array.getLength(propertyValue);
            if (lenght < index && options.isOutOfBoundsSafety) {
                return null;
            }
            try {
                return Array.get(propertyValue, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("The indexed " + property + " in " + obj.getClass().getSimpleName() + " object has only '" + lenght + "' elements, but index '" + index + "' requested.");
            }
        }
        if (propertyValue instanceof Iterable) {
            Iterable iterable = (Iterable)propertyValue;
            int k = 0;
            for (Object object : iterable) {
                if (k == index) {
                    return object;
                }
                ++k;
            }
            if (options.isOutOfBoundsSafety) {
                return null;
            }
            throw new IndexOutOfBoundsException("The indexed " + property + " in " + obj.getClass().getSimpleName() + " object has less than '" + index + "' elements.");
        }
        throw new IllegalArgumentException("Cannot get an indexed value from the not indexed " + property + ". Only List, array and Iterable types are supported, but " + property.getType().getSimpleName() + " found.");
    }

    private static Object getMappedValue(Object obj, Property property, Object key) {
        if (property == null) {
            throw new IllegalArgumentException("Cannot get the mapped value from a 'null' property.");
        }
        if (property.getType().isAssignableFrom(Map.class)) {
            Map map = (Map)property.get(obj);
            if (map == null) {
                throw new NullPointerException("Invalid 'null' value found for mapped " + property + " in " + obj.getClass().getName() + ".");
            }
            return map.get(key);
        }
        throw new IllegalArgumentException("Cannot get a mapped value from the not mapped " + property + ". Only Map type is supported, but " + property.getType().getSimpleName() + " found.");
    }

    private static void setValue(Object obj, String propertyPattern, Object value, ObjectWrapper options) {
        if (propertyPattern == null) {
            throw new IllegalArgumentException("Cannot set a new value to a property with a 'null' propertyPattern.");
        }
        if (obj == null) {
            throw new NullPointerException("Cannot set the value of '" + propertyPattern + "' to a 'null' object.");
        }
        int position = ObjectWrapper.indexOfDotOrSquare(propertyPattern);
        if (position > 0) {
            String leftPattern = propertyPattern.substring(0, position);
            String rightPattern = propertyPattern.substring(position + 1, propertyPattern.length());
            Object leftValue = ObjectWrapper.getValue(obj, leftPattern, options);
            if (leftValue == null) {
                Property leftProperty = ObjectWrapper.getPropertyOrThrow(Bean.forClass(obj.getClass()), leftPattern);
                if (options.isAutoInstancing) {
                    try {
                        leftValue = leftProperty.getType().newInstance();
                    }
                    catch (Exception e) {
                        throw new ReflectionException("The value of " + leftProperty + " was 'null' in the object " + obj.getClass().getName() + ". An attempt to invoke its 'no-args constructor' was made, but an error occurs.", e);
                    }
                    leftProperty.set(obj, leftValue);
                }
            }
            ObjectWrapper.setValue(leftValue, rightPattern, value, options);
        } else if (position < 0) {
            int squarePosition = -position;
            String leftPattern = propertyPattern.substring(0, squarePosition);
            String indexOrKey = propertyPattern.substring(squarePosition + 1, propertyPattern.length() - 1);
            Property leftProperty = ObjectWrapper.getPropertyOrThrow(Bean.forClass(obj.getClass()), leftPattern);
            if (leftProperty.getType().isAssignableFrom(Map.class)) {
                ObjectWrapper.setMappedValue(obj, leftProperty, indexOrKey, value, options);
            } else {
                try {
                    ObjectWrapper.setIndexedValue(obj, leftProperty, Integer.parseInt(indexOrKey), value, options);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The pattern '" + indexOrKey + "' for the indexed " + leftProperty + " is invalid. Cannot parse the string to a valid integer index.");
                }
            }
        } else {
            ObjectWrapper.setSimpleValue(obj, ObjectWrapper.getPropertyOrThrow(Bean.forClass(obj.getClass()), propertyPattern), value);
        }
    }

    private static void setSimpleValue(Object obj, Property property, Object value) {
        if (property == null) {
            throw new IllegalArgumentException("Cannot set a new value to a property with a 'null' propertyName.");
        }
        property.set(obj, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setIndexedValue(Object obj, Property property, int index, Object value, ObjectWrapper options) {
        if (property == null) {
            throw new IllegalArgumentException("Cannot set a new indexed value to a 'null' property.");
        }
        ArrayList propertyValue = property.get(obj);
        if (propertyValue == null) {
            if (!options.isAutoInstancing) throw new NullPointerException("Invalid 'null' value found for the indexed '" + property + "' in " + obj.getClass().getName() + " object.");
            Class<List> propertyType = property.getType();
            if (propertyType.isAssignableFrom(List.class)) {
                propertyValue = new ArrayList();
                property.set(obj, propertyValue);
            } else {
                if (!propertyType.isArray()) throw new IllegalArgumentException("The indexed " + property + " in object " + obj.getClass().getSimpleName() + " has value 'null'. Only List and array types can be auto instantiated, but " + propertyType.getSimpleName() + " found.");
                propertyValue = Array.newInstance(property.getActualType(), index + 1);
                property.set(obj, propertyValue);
            }
        }
        if (propertyValue instanceof List) {
            List list = propertyValue;
            int size = list.size();
            if (index >= size && options.isAutoGrowing) {
                for (int i = size; i < index; ++i) {
                    try {
                        list.add(null);
                        continue;
                    }
                    catch (NullPointerException ex) {
                        throw new NullPointerException("The indexed " + property + " has size lower than the requested '" + index + "' index. An attempt to autogrowing it, filling with 'null' values, was made,  but the List implementation seems to do not accept 'null' values. " + ex.getMessage());
                    }
                }
                list.add(index, value);
                return;
            } else {
                try {
                    list.set(index, value);
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IndexOutOfBoundsException("Cannot set a new value to the indexed list " + property + " in " + obj.getClass().getSimpleName() + " as the requested '" + index + "' index is unbound.");
                }
            }
        }
        if (!propertyValue.getClass().isArray()) throw new IllegalArgumentException("Cannot set a new value to a not indexed " + property + ". Only List and array types are supported, but " + propertyValue.getClass().getName() + " found.");
        int length = Array.getLength(propertyValue);
        if (index >= length && options.isAutoGrowing) {
            Object biggerArray = Array.newInstance(property.getActualType(), index + 1);
            System.arraycopy(propertyValue, 0, biggerArray, 0, length);
            property.set(obj, biggerArray);
            propertyValue = biggerArray;
        }
        try {
            Array.set(propertyValue, index, value);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Cannot set a new value to the indexed array " + property + " in " + obj.getClass().getSimpleName() + " as the requested '" + index + "' index is unbound.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setMappedValue(Object obj, Property property, Object key, Object value, ObjectWrapper options) {
        if (property == null) {
            throw new IllegalArgumentException("Cannot set a new mapped value to a 'null' property.");
        }
        if (!Map.class.isAssignableFrom(property.getType())) throw new IllegalArgumentException("Cannot set a new mapped value to " + property + ". Only Map type is supported for mapped properties, but " + property.getType().getName() + " found.");
        LinkedHashMap<Object, Object> map = (LinkedHashMap<Object, Object>)property.get(obj);
        if (map == null) {
            if (!options.isAutoInstancing) throw new NullPointerException("Invalid 'null' value found for the mapped '" + property + "' in " + obj.getClass().getName() + " object.");
            map = new LinkedHashMap<Object, Object>();
            property.set(obj, map);
        }
        map.put(key, value);
    }
}

