/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.beans.reflect;

import com.fluentinterface.beans.reflect.Property;
import java.lang.ref.SoftReference;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Bean<T> {
    private static final Map<Class<?>, SoftReference<Bean<?>>> beansCache = new ConcurrentHashMap();
    private final Class<T> type;
    private final Map<String, Property> properties;
    private final Map<String, Property> declaredProperties;

    public static <T> Bean<T> forClass(Class<T> beanClass) {
        Bean<Object> bean;
        if (beanClass == null) {
            throw new NullPointerException("Cannot instrospect a bean with a 'null' beanClass.");
        }
        SoftReference<Bean<?>> softReference = beansCache.get(beanClass);
        if (softReference == null) {
            bean = new Bean<T>(beanClass);
            beansCache.put(beanClass, new SoftReference(bean));
        } else {
            bean = softReference.get();
            if (bean == null) {
                bean = new Bean<T>(beanClass);
                beansCache.put(beanClass, new SoftReference(bean));
            }
        }
        return bean;
    }

    private Bean(Class<T> type) {
        this.type = type;
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (PropertyDescriptor descriptor : Bean.getPropertyDescriptors(type.getMethods())) {
            Property property = new Property(this, descriptor.name, descriptor.readMethod, descriptor.writeMethod);
            properties.put(property.getName(), property);
        }
        HashMap<String, Property> declaredProperties = new HashMap<String, Property>();
        for (PropertyDescriptor descriptor : Bean.getPropertyDescriptors(type.getDeclaredMethods())) {
            Property declaredProperty = new Property(this, descriptor.name, descriptor.readMethod, descriptor.writeMethod);
            if (properties.containsValue(declaredProperty)) {
                declaredProperties.put(declaredProperty.getName(), (Property)properties.get(declaredProperty.getName()));
                continue;
            }
            declaredProperties.put(declaredProperty.getName(), declaredProperty);
        }
        this.properties = Bean.optimizeMap(properties);
        this.declaredProperties = Bean.optimizeMap(declaredProperties);
    }

    private static Collection<PropertyDescriptor> getPropertyDescriptors(Method[] methods) {
        ArrayList<PropertyDescriptor> desciptorsHolder = new ArrayList<PropertyDescriptor>();
        for (Method method : methods) {
            PropertyDescriptor info;
            if (Bean.isStatic(method) || method.isSynthetic()) continue;
            String name = method.getName();
            if (method.getParameterTypes().length == 0) {
                if (name.length() > 3 && name.startsWith("get") && method.getReturnType() != Void.TYPE) {
                    info = new PropertyDescriptor();
                    info.name = Bean.uncapitalize(name.substring(3));
                    info.readMethod = method;
                    info.isGetter = true;
                    desciptorsHolder.add(info);
                    continue;
                }
                if (name.length() <= 2 || !name.startsWith("is") || method.getReturnType() != Boolean.TYPE) continue;
                info = new PropertyDescriptor();
                info.name = Bean.uncapitalize(name.substring(2));
                info.readMethod = method;
                info.isIsser = true;
                desciptorsHolder.add(info);
                continue;
            }
            if (method.getParameterTypes().length != 1 || name.length() <= 3 || !name.startsWith("set") || method.getReturnType() != Void.TYPE) continue;
            info = new PropertyDescriptor();
            info.name = Bean.uncapitalize(name.substring(3));
            info.writeMethod = method;
            info.isSetter = true;
            desciptorsHolder.add(info);
        }
        HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : desciptorsHolder) {
            PropertyDescriptor instance = (PropertyDescriptor)descriptors.get(descriptor.name);
            if (instance == null) {
                descriptors.put(descriptor.name, descriptor);
                instance = descriptor;
            }
            if (descriptor.isIsser) {
                instance.readMethod = descriptor.readMethod;
                continue;
            }
            if (descriptor.isGetter) {
                if (instance.readMethod != null) continue;
                instance.readMethod = descriptor.readMethod;
                continue;
            }
            if (!descriptor.isSetter) continue;
            instance.writeMethod = descriptor.writeMethod;
        }
        return descriptors.values();
    }

    private static String uncapitalize(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static boolean isPrivate(Member member) {
        return member != null && Modifier.isPrivate(member.getModifiers());
    }

    static boolean isPublic(Member member) {
        return member != null && Modifier.isPublic(member.getModifiers());
    }

    static boolean isStatic(Member member) {
        return member != null && Modifier.isStatic(member.getModifiers());
    }

    public Class<T> getType() {
        return this.type;
    }

    public Property getProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("Cannot get a property with a 'null' propertyName.");
        }
        return this.properties.get(propertyName);
    }

    public Property getDeclaredProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("Cannot get a declared property with a 'null' propertyName.");
        }
        return this.declaredProperties.get(propertyName);
    }

    public Property[] getProperties() {
        return this.properties.values().toArray(new Property[this.properties.size()]);
    }

    public Property[] getDeclaredProperties() {
        return this.declaredProperties.values().toArray(new Property[this.declaredProperties.size()]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Bean other = (Bean)obj;
        return this.type.equals(other.type);
    }

    public int hashCode() {
        return this.type.getName().hashCode();
    }

    public String toString() {
        return "bean " + this.type.getName();
    }

    static <K, V> Map<K, V> optimizeMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        return map;
    }

    private static final class PropertyDescriptor {
        public String name;
        public Method readMethod;
        public Method writeMethod;
        public boolean isIsser;
        public boolean isGetter;
        public boolean isSetter;

        private PropertyDescriptor() {
        }
    }
}

