/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.beans.reflect;

import com.fluentinterface.beans.reflect.Bean;
import com.fluentinterface.beans.reflect.ReflectionException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public final class Property
implements AnnotatedElement {
    private final String name;
    private final Field field;
    private final Method readMethod;
    private final Method writeMethod;
    private final ProxyMethod proxyReadMethod;
    private final ProxyMethod proxyWriteMethod;
    private final Class<?> type;
    private final Class<?> actualType;
    private final Bean<?> declaringBean;
    private final Type genericType;
    private final int hashCode;
    private final Map<Class<? extends Annotation>, Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> declaredAnnotations;

    Property(Bean<?> declaringBean, String name, Method readMethod, Method writeMethod) {
        Class candidateActualType;
        this.name = name;
        this.declaringBean = declaringBean;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.hashCode = declaringBean.getType().getName().hashCode() ^ name.hashCode();
        if (writeMethod != null) {
            this.type = writeMethod.getParameterTypes()[0];
            this.genericType = writeMethod.getGenericParameterTypes()[0];
        } else {
            this.type = readMethod.getReturnType();
            this.genericType = readMethod.getGenericReturnType();
        }
        try {
            candidateActualType = this.type.isArray() ? this.type.getComponentType() : (Iterable.class.isAssignableFrom(this.type) ? (Class)((ParameterizedType)this.genericType).getActualTypeArguments()[0] : (Map.class.isAssignableFrom(this.type) ? (Class)((ParameterizedType)this.genericType).getActualTypeArguments()[1] : this.type));
        }
        catch (Exception e) {
            candidateActualType = null;
        }
        this.actualType = candidateActualType;
        this.proxyReadMethod = readMethod != null ? new ProxyMethod(readMethod) : null;
        this.proxyWriteMethod = writeMethod != null ? new ProxyMethod(writeMethod) : null;
        this.field = Property.findAccessorField(declaringBean.getType(), name, this.type);
        HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>(4);
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotations = new HashMap<Class<? extends Annotation>, Annotation>(4);
        for (AnnotatedElement element : new AnnotatedElement[]{this.field, readMethod, writeMethod}) {
            Class<? extends Annotation> annotationType;
            if (element == null) continue;
            for (Annotation annotation : element.getAnnotations()) {
                annotationType = annotation.annotationType();
                annotations.put(annotationType, annotation);
            }
            if (((Member)((Object)element)).getDeclaringClass() != declaringBean.getType()) continue;
            for (Annotation annotation : element.getDeclaredAnnotations()) {
                annotationType = annotation.annotationType();
                declaredAnnotations.put(annotationType, annotation);
            }
        }
        this.annotations = Bean.optimizeMap(annotations);
        this.declaredAnnotations = Bean.optimizeMap(declaredAnnotations);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[this.annotations.size()]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations.values().toArray(new Annotation[this.declaredAnnotations.size()]);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Cannot get an annotation with a 'null' annotationClass.");
        }
        return (T)((Annotation)annotationClass.cast(this.annotations.get(annotationClass)));
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Cannot get a declared annotation with a 'null' annotationClass.");
        }
        return (T)((Annotation)annotationClass.cast(this.declaredAnnotations.get(annotationClass)));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Cannot check the presence of an annotation with a 'null' annotationClass.");
        }
        return this.annotations.containsKey(annotationClass);
    }

    public Bean<?> getDeclaringBean() {
        return this.declaringBean;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getActualType() {
        return this.actualType;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Method getReadMethod() {
        if (this.readMethod == null) {
            return null;
        }
        try {
            return this.readMethod.getDeclaringClass().getDeclaredMethod(this.readMethod.getName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public Method getWriteMethod() {
        if (this.writeMethod == null) {
            return null;
        }
        try {
            return this.writeMethod.getDeclaringClass().getDeclaredMethod(this.writeMethod.getName(), this.type);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public Field getField() {
        if (this.field == null) {
            return null;
        }
        try {
            return this.field.getDeclaringClass().getDeclaredField(this.field.getName());
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public boolean isReadable() {
        return Bean.isPublic(this.readMethod);
    }

    public boolean isWritable() {
        return Bean.isPublic(this.writeMethod);
    }

    public Object get(Object obj) throws ReflectionException {
        try {
            if (Bean.isPublic(this.readMethod)) {
                return this.proxyReadMethod.invoke(obj, null);
            }
            throw new ReflectionException("Cannot get the value of " + this + ", as it is write-only.");
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot get the value of " + this + " in object " + obj, e);
        }
    }

    public void set(Object obj, Object value) throws ReflectionException {
        try {
            if (!Bean.isPublic(this.writeMethod)) {
                throw new ReflectionException("Cannot set the value of " + this + ", as it is read-only.");
            }
            this.proxyWriteMethod.invoke(obj, new Object[]{value});
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot set the value of " + this + " to object " + obj, e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.readMethod != null ? !this.readMethod.equals(other.readMethod) : other.readMethod != null) {
            return false;
        }
        if (this.writeMethod != null ? !this.writeMethod.equals(other.writeMethod) : other.writeMethod != null) {
            return false;
        }
        return this.declaringBean.equals(other.declaringBean);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static Field findAccessorField(Class<?> type, String name, Class<?> requiredType) {
        for (Class<?> current = type; current != null; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (!field.getName().equals(name) || !field.getType().equals(requiredType) || Bean.isStatic(field) || field.isSynthetic() || Bean.isPrivate(field) && field.getDeclaringClass() != type) continue;
                return field;
            }
        }
        return null;
    }

    public String toString() {
        return "property " + this.declaringBean.getType().getName() + "." + this.name;
    }

    private static final class ProxyMethod {
        private static boolean isCglibPresent = false;
        private Method method;
        private FastMethod fastMethod;

        public ProxyMethod(Method method) {
            this.method = method;
            if (isCglibPresent) {
                try {
                    PrintStream err = System.err;
                    System.setErr(null);
                    this.fastMethod = FastClass.create(method.getDeclaringClass()).getMethod(method);
                    System.setErr(err);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Object invoke(Object obj, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (isCglibPresent && this.fastMethod != null) {
                return this.fastMethod.invoke(obj, args);
            }
            return this.method.invoke(obj, args);
        }

        static {
            try {
                isCglibPresent = Class.forName("net.sf.cglib.reflect.FastMethod") != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

