/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.convert;

import com.fluentinterface.convert.Converter;
import com.fluentinterface.convert.Converters;
import com.fluentinterface.convert.PathMatcher;
import com.fluentinterface.convert.TypeMatcher;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.type.NullType;

public class Conversions {
    private final LinkedList<ConverterEntry> converters = new LinkedList();

    private Conversions(List<ConverterEntry> converters) {
        this.converters.addAll(converters);
    }

    public static Conversions empty() {
        return new Conversions(Collections.emptyList());
    }

    public static Conversions defaults() {
        return Conversions.empty().addDefaultConverters();
    }

    public static Conversions of(Conversions ... conversions) {
        return new Conversions(Arrays.stream(conversions).map(c -> c.converters).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public <S, T> Conversions add(TypeMatcher<S> source, TypeMatcher<T> destination, Convert<S, T> converter) {
        return this.add(PathMatcher.match(source, destination), converter);
    }

    public <S, T> Conversions add(PathMatcher<S, T> matcher, Convert<S, T> converter) {
        this.converters.add(new ConverterEntry(matcher, converter));
        return this;
    }

    public Conversions addDefaultConverters() {
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Boolean.TYPE), (v, t, c) -> false);
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Character.TYPE), (v, t, c) -> Character.valueOf('\u0000'));
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Byte.TYPE), (v, t, c) -> (byte)0);
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Short.TYPE), (v, t, c) -> (short)0);
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Integer.TYPE), (v, t, c) -> 0);
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Long.TYPE), (v, t, c) -> 0L);
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Float.TYPE), (v, t, c) -> Float.valueOf(0.0f));
        this.add(TypeMatcher.nulls(), TypeMatcher.is(Double.TYPE), (v, t, c) -> 0.0);
        this.add(TypeMatcher.nulls(), TypeMatcher.any(), (v, t, c) -> null);
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Boolean.class, Boolean.TYPE}), (v, t, c) -> Boolean.parseBoolean(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Character.class, Character.TYPE}), (v, t, c) -> Character.valueOf(v.length() > 0 ? v.charAt(0) : (char)'\u0000'));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Short.class, Short.TYPE}), (v, t, c) -> Short.parseShort(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Byte.class, Byte.TYPE}), (v, t, c) -> Byte.parseByte(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Integer.class, Integer.TYPE}), (v, t, c) -> Integer.parseInt(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Long.class, Long.TYPE}), (v, t, c) -> Long.parseLong(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Float.class, Float.TYPE}), (v, t, c) -> Float.valueOf(Float.parseFloat(v)));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(new Type[]{Double.class, Double.TYPE}), (v, t, c) -> Double.parseDouble(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(BigDecimal.class), (v, t, c) -> BigDecimal.valueOf(Double.parseDouble(v)));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(BigInteger.class), (v, t, c) -> BigInteger.valueOf(Long.parseLong(v)));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(Date.class), Converters.stringToDate);
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(LocalDate.class), (v, t, c) -> LocalDate.parse(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(LocalTime.class), (v, t, c) -> LocalTime.parse(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(LocalDateTime.class), (v, t, c) -> LocalDateTime.parse(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(ZonedDateTime.class), (v, t, c) -> ZonedDateTime.parse(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.is(Instant.class), (v, t, c) -> Instant.parse(v));
        this.add(TypeMatcher.is(String.class), TypeMatcher.isInstanceOf(Enum.class), Converters.stringToEnum());
        this.add(TypeMatcher.any(), TypeMatcher.is(String.class), (v, t, c) -> v.toString());
        return this;
    }

    Optional<Convert> find(Type source, Type target) {
        Object sourceType = source != null ? source : NullType.class;
        Type targetType = target;
        return this.converters.stream().filter(arg_0 -> Conversions.lambda$find$26((Type)sourceType, targetType, arg_0)).findFirst().map(c -> ((ConverterEntry)c).converter);
    }

    private static /* synthetic */ boolean lambda$find$26(Type sourceType, Type targetType, ConverterEntry c) {
        return c.matcher.matches(sourceType, targetType);
    }

    private static class ConverterEntry {
        private final PathMatcher matcher;
        private final Convert converter;

        private ConverterEntry(PathMatcher matcher, Convert converter) {
            this.matcher = matcher;
            this.converter = converter;
        }
    }

    @FunctionalInterface
    public static interface Convert<S, T> {
        public T convert(S var1, Class<T> var2, Converter var3);
    }
}

