/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.convert;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import javax.lang.model.type.NullType;

public interface TypeMatcher<T> {
    public boolean matches(Type var1);

    public static TypeMatcher<?> any() {
        return t -> true;
    }

    public static TypeMatcher<?> nulls() {
        return t -> t.equals(NullType.class);
    }

    public static <T> TypeMatcher<T> is(Class<T> type) {
        return t -> t.equals(type);
    }

    public static TypeMatcher<? super Object> is(Type ... types) {
        HashSet<Type> typeSet = new HashSet<Type>(Arrays.asList(types));
        return typeSet::contains;
    }

    public static <T> TypeMatcher<T> isInstanceOf(Class<? extends T> numberClass) {
        return t -> numberClass.isAssignableFrom((Class)t);
    }
}

