/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.proxy;

import com.fluentinterface.proxy.BuilderDelegate;
import com.fluentinterface.utils.GenericsUtils;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class AbstractBuilderDelegate<B>
implements BuilderDelegate<B> {
    private Method buildMethod;

    public AbstractBuilderDelegate() {
        try {
            this.buildMethod = this.getBuilderClass().getDeclaredMethod(this.getBuildMethodName(), Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Could not find [%s] method on [%s] class.", this.getBuildMethodName(), this.getBuilderClass()), e);
        }
    }

    protected abstract String getBuildMethodName();

    protected abstract Class<B> getBuilderClass();

    @Override
    public Class<?> getClassBuiltBy(Class<?> builderInterface) {
        return GenericsUtils.getDeclaredGenericType(builderInterface, this.getBuilderClass());
    }

    @Override
    public Class<?> getClassBuiltBy(Object builder) {
        return Arrays.stream(builder.getClass().getInterfaces()).filter(clazz -> this.getBuilderClass().isAssignableFrom((Class<?>)clazz)).map(this::getClassBuiltBy).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Could not determine which class builder [%s] builds", builder.getClass())));
    }

    @Override
    public boolean isBuilderInstance(Object value) {
        return this.getBuilderClass().isInstance(value);
    }

    @Override
    public boolean isBuildMethod(Method method) {
        return method.equals(this.buildMethod);
    }
}

