/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.proxy.internal;

import com.fluentinterface.proxy.BuilderDelegate;
import com.fluentinterface.proxy.BuilderState;
import com.fluentinterface.proxy.Instantiator;
import com.fluentinterface.utils.TypeConversionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

class BestMatchingConstructor<T>
implements Instantiator<T> {
    private Class<T> builtClass;
    private BuilderDelegate<?> builderDelegate;
    private Object[] params;

    BestMatchingConstructor(Class<T> builtClass, BuilderDelegate<?> builderDelegate, Object[] params) {
        this.builtClass = builtClass;
        this.builderDelegate = builderDelegate;
        this.params = params;
    }

    @Override
    public T instantiate(BuilderState state) throws InstantiationException {
        try {
            Constructor<T> constructor = this.findConstructorMatching(this.params);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            for (int i = 0; i < this.params.length; ++i) {
                Class<?> targetType = constructor.getParameterTypes()[i];
                this.params[i] = state.coerce(this.params[i], targetType);
            }
            return constructor.newInstance(this.params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Constructor<T> findConstructorMatching(Object[] params) throws NoSuchMethodException {
        if (params == null || params.length == 0) {
            return this.builtClass.getDeclaredConstructor(new Class[0]);
        }
        Object[] paramTypes = this.extractTypesFromValues(params);
        List<Constructor<T>> candidates = this.findCandidateConstructors((Class<?>[])paramTypes);
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException(String.format("No constructor found on class [%s] that matches signature (%s)", this.builtClass, Arrays.toString(paramTypes)));
        }
        if (candidates.size() > 1) {
            throw new IllegalArgumentException(String.format("Found %s constructors matching signature (%s) on class [%s], which is too ambiguous to proceed.", candidates.size(), Arrays.toString(paramTypes), this.builtClass));
        }
        return candidates.get(0);
    }

    private Class<?>[] extractTypesFromValues(Object[] params) {
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            paramTypes[i] = this.builderDelegate.isBuilderInstance(param) ? this.builderDelegate.getClassBuiltBy(param) : (param == null ? null : param.getClass());
        }
        return paramTypes;
    }

    private List<Constructor<T>> findCandidateConstructors(Class<?>[] paramTypes) {
        Constructor<?>[] allConstructors = this.builtClass.getDeclaredConstructors();
        ArrayList<Constructor<T>> candidates = new ArrayList<Constructor<T>>();
        for (Constructor<?> constructor : allConstructors) {
            Class<?>[] constructorParamTypes = constructor.getParameterTypes();
            if (constructorParamTypes.length != paramTypes.length || !this.typesAreCompatible(paramTypes, constructorParamTypes)) continue;
            candidates.add(constructor);
        }
        return candidates;
    }

    private boolean typesAreCompatible(Class<?>[] paramTypes, Class<?>[] constructorParamTypes) {
        boolean matches = true;
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (paramType == null) continue;
            Class<?> inputParamType = TypeConversionUtils.translateFromPrimitive(paramType);
            Class<?> constructorParamType = TypeConversionUtils.translateFromPrimitive(constructorParamTypes[i]);
            if (inputParamType.isArray() && Collection.class.isAssignableFrom(constructorParamType) || constructorParamType.isAssignableFrom(inputParamType)) continue;
            matches = false;
            break;
        }
        return matches;
    }
}

