/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.proxy.internal;

import com.fluentinterface.annotation.Constructs;
import com.fluentinterface.proxy.BuilderDelegate;
import com.fluentinterface.proxy.BuilderState;
import com.fluentinterface.proxy.Instantiator;
import com.fluentinterface.proxy.PropertyAccessStrategy;
import com.fluentinterface.proxy.PropertySetter;
import com.fluentinterface.proxy.PropertyTarget;
import com.fluentinterface.proxy.internal.BestMatchingConstructor;
import com.fluentinterface.proxy.internal.BuildWithBuilder;
import com.fluentinterface.proxy.internal.CoerceValueConverter;
import com.fluentinterface.proxy.internal.EmptyConstructor;
import com.fluentinterface.proxy.internal.PropertySetterFactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class BuilderProxy<T>
implements InvocationHandler {
    private Class proxied;
    private Class<T> builtClass;
    private BuilderDelegate builderDelegate;
    private PropertyAccessStrategy propertyAccessStrategy;
    private Map<PropertySetter, Object> settersWithValues;
    private Instantiator<T> instantiator;
    private PropertySetterFactory setterFactory;

    public BuilderProxy(Class builderInterface, Class<T> builtClass, BuilderDelegate builderDelegate, PropertyAccessStrategy propertyAccessStrategy, Instantiator instantiator) {
        this.proxied = builderInterface;
        this.builtClass = builtClass;
        this.builderDelegate = builderDelegate;
        this.propertyAccessStrategy = propertyAccessStrategy;
        this.settersWithValues = new LinkedHashMap<PropertySetter, Object>();
        this.instantiator = instantiator != null ? instantiator : new EmptyConstructor<T>(builtClass);
        this.setterFactory = new PropertySetterFactory(propertyAccessStrategy, builtClass, builderDelegate);
    }

    @Override
    public Object invoke(Object target, Method method, Object[] params) throws Throwable {
        if (method.isDefault()) {
            return this.invokeDefaultMethod(target, method, params);
        }
        if (this.isConstructingMethod(method)) {
            this.instantiator = new BestMatchingConstructor<T>(this.builtClass, this.builderDelegate, params);
            return target;
        }
        if (this.isBuildMethod(method)) {
            if ((params = this.extractVarArgsIfNeeded(params)).length > 0) {
                this.buildIfBuilderInstances(params);
                this.instantiator = new BestMatchingConstructor<T>(this.builtClass, this.builderDelegate, params);
            }
            return this.createInstanceFromProperties();
        }
        if (this.isFluentSetter(method)) {
            PropertySetter setter = this.setterFactory.createPropertySetter(method);
            Object valueForProperty = params == null || params.length == 0 ? null : params[0];
            this.settersWithValues.put(setter, valueForProperty);
            return target;
        }
        throw new IllegalStateException("Unrecognized builder method invocation: " + method);
    }

    private Object createInstanceFromProperties() throws Exception {
        T instance = this.instantiator.instantiate(new State());
        PropertyTarget target = this.propertyAccessStrategy.targetFor(instance);
        for (Map.Entry<PropertySetter, Object> entry : this.settersWithValues.entrySet()) {
            PropertySetter setter = entry.getKey();
            Object value = entry.getValue();
            setter.apply(target, value);
        }
        return instance;
    }

    private void buildIfBuilderInstances(Object[] params) {
        BuildWithBuilder builder = new BuildWithBuilder(this.builderDelegate);
        for (int i = 0; i < params.length; ++i) {
            params[i] = builder.apply(params[i]);
        }
    }

    private boolean hasBuilderDelegate() {
        return this.builderDelegate != null;
    }

    private boolean isFluentSetter(Method method) {
        return method.getReturnType().isAssignableFrom(this.proxied) && !this.isBuildMethod(method);
    }

    private boolean isConstructingMethod(Method method) {
        return method.getAnnotation(Constructs.class) != null && method.getReturnType().isAssignableFrom(this.proxied);
    }

    private boolean isBuildMethod(Method method) {
        if (this.hasBuilderDelegate()) {
            return this.builderDelegate.isBuildMethod(method);
        }
        return method.getReturnType() == Object.class;
    }

    private Object[] extractVarArgsIfNeeded(Object[] params) {
        if (params != null && params.length == 1 && params[params.length - 1].getClass().isArray()) {
            return (Object[])params[params.length - 1];
        }
        return params;
    }

    private Object invokeDefaultMethod(Object target, Method method, Object[] params) throws Throwable {
        try {
            return this.invokeDefaultMethodJava8(target, method, params);
        }
        catch (IllegalAccessException e) {
            return this.invokeDefaultMethodJava9(target, method, params);
        }
    }

    private Object invokeDefaultMethodJava8(Object target, Method method, Object[] params) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        constructor.setAccessible(true);
        return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 2)).unreflectSpecial(method, declaringClass).bindTo(target).invokeWithArguments(params);
    }

    private Object invokeDefaultMethodJava9(Object target, Method method, Object[] params) throws Throwable {
        return MethodHandles.lookup().findSpecial(this.proxied, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), this.proxied).bindTo(target).invokeWithArguments(params);
    }

    private class State
    implements BuilderState {
        private BuildWithBuilder builderConverter;

        State() {
            this.builderConverter = new BuildWithBuilder(BuilderProxy.this.builderDelegate);
        }

        @Override
        public boolean hasValueFor(String ... properties) {
            return Arrays.stream(properties).allMatch(prop -> this.findSetterFor((String)prop).isPresent());
        }

        @Override
        public <P> Optional<P> peek(String property, Class<P> type) {
            return this.findSetterFor(property).map(setter -> {
                Object value = BuilderProxy.this.settersWithValues.get(setter);
                return this.getValueForTargetProperty((PropertySetter)setter, value);
            });
        }

        @Override
        public <P> Optional<P> consume(String property, Class<P> type) {
            return this.findSetterFor(property).map(setter -> {
                Object value = BuilderProxy.this.settersWithValues.remove(setter);
                return this.getValueForTargetProperty((PropertySetter)setter, value);
            });
        }

        @Override
        public Object coerce(Object value, Class<?> targetType) {
            return new CoerceValueConverter(targetType, this.builderConverter).apply(value);
        }

        private Optional<PropertySetter> findSetterFor(String property) {
            for (Map.Entry setterEntries : BuilderProxy.this.settersWithValues.entrySet()) {
                PropertySetter setter = (PropertySetter)setterEntries.getKey();
                if (!property.equals(setter.getPropertyName())) continue;
                return Optional.of(setter);
            }
            return Optional.empty();
        }

        private <P> P getValueForTargetProperty(PropertySetter setter, Object value) {
            PropertyHolder holder = new PropertyHolder();
            try {
                setter.apply(holder, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return holder.value;
        }

        private class PropertyHolder<P>
        implements PropertyTarget {
            public P value;

            private PropertyHolder() {
            }

            @Override
            public void setProperty(String property, Object value) {
                this.value = value;
            }
        }
    }
}

