/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.proxy.internal;

import com.fluentinterface.convert.Converter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

class CoerceValueConverter
implements Function {
    private final Converter converter;
    private Class targetType;
    private final Function<Object, Object> next;

    CoerceValueConverter(Class targetType, Function<Object, Object> next) {
        this.targetType = targetType;
        this.next = next;
        this.converter = new Converter();
    }

    public Object apply(Object value) {
        if (this.targetType == null) {
            return value;
        }
        try {
            if (value != null) {
                Collection<Object> valueAsCollection = this.convertToCollectionIfMultiValued(value);
                if (valueAsCollection != null) {
                    valueAsCollection = this.applyNextFunctionToElements(valueAsCollection);
                    value = this.transformCollectionToTargetTypeIfPossible(value, valueAsCollection, this.targetType);
                    return value;
                }
                value = this.next.apply(value);
                value = this.convert(value);
            } else {
                value = this.convert(null);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    private Object convert(Object value) {
        return this.converter.convert(value, this.targetType);
    }

    private Object transformCollectionToTargetTypeIfPossible(Object originalValue, Collection<Object> valueAsCollection, Class targetPropertyType) throws InstantiationException, IllegalAccessException {
        if (targetPropertyType.isArray()) {
            return this.collectionToArray(valueAsCollection, targetPropertyType);
        }
        Collection<Object> targetValue = this.createCollectionOfType(targetPropertyType);
        if (targetValue != null) {
            targetValue.addAll(valueAsCollection);
            return targetValue;
        }
        return originalValue;
    }

    private Collection<Object> applyNextFunctionToElements(Collection<Object> collectionWithBuilders) {
        ArrayList<Object> transformed = new ArrayList<Object>(collectionWithBuilders.size());
        for (Object element : collectionWithBuilders) {
            element = this.next.apply(element);
            transformed.add(element);
        }
        return transformed;
    }

    private Collection<Object> convertToCollectionIfMultiValued(Object value) {
        Class<?> valueClass = value.getClass();
        Collection valueAsCollection = null;
        if (valueClass.isArray()) {
            valueAsCollection = this.arrayToCollection(value);
        } else if (this.isCollection(valueClass)) {
            valueAsCollection = (Collection)value;
        }
        return valueAsCollection;
    }

    private Object collectionToArray(Collection<Object> valueAsCollection, Class targetPropertyType) {
        Class<?> arrayElementsType = targetPropertyType.getComponentType();
        int arraySize = valueAsCollection.size();
        Object createdArray = Array.newInstance(arrayElementsType, arraySize);
        int idx = 0;
        for (Object arrayElement : valueAsCollection) {
            Array.set(createdArray, idx++, arrayElement);
        }
        return createdArray;
    }

    private Collection<Object> arrayToCollection(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(String.format("[%s] is not an array.", array));
        }
        int arrayLength = Array.getLength(array);
        ArrayList<Object> converted = new ArrayList<Object>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            Object currentElement = Array.get(array, i);
            converted.add(currentElement);
        }
        return converted;
    }

    private boolean isCollection(Class clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    private Collection<Object> createCollectionOfType(Class clazz) throws IllegalAccessException, InstantiationException {
        if (!this.isCollection(clazz)) {
            throw new IllegalArgumentException(String.format("Class [%s] is not a collection.", clazz));
        }
        if (clazz.isInterface()) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new TreeSet<Object>();
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new HashSet<Object>();
            }
            if (List.class.isAssignableFrom(clazz)) {
                return new ArrayList<Object>();
            }
            return null;
        }
        return (Collection)clazz.newInstance();
    }
}

