/*
 * Decompiled with CFR 0.152.
 */
package com.fluentinterface.proxy.internal;

import com.fluentinterface.proxy.PropertyAccessStrategy;
import java.lang.reflect.Field;

public class FieldPropertyAccessStrategy
implements PropertyAccessStrategy {
    public boolean hasProperty(Class<?> builtClass, String property) {
        Field field = this.getFieldFromClass(builtClass, property);
        return field != null;
    }

    public Class getPropertyType(Class targetClass, String property) {
        if (targetClass == null) {
            return null;
        }
        Field field = this.getFieldFromClass(targetClass, property);
        if (field == null) {
            throw new IllegalStateException(String.format("No property named '%s' was found on class %s", property, targetClass));
        }
        return field.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyValue(Object target, String property, Object value) throws Exception {
        Field field = this.getFieldFromClass(target.getClass(), property);
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    protected Field getFieldFromClass(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return this.findFieldFromAncestors(clazz, fieldName);
        }
    }

    protected Field findFieldFromAncestors(Class<?> clazz, String fieldName) {
        Class<?> parent = clazz.getSuperclass();
        if (parent == Object.class) {
            return null;
        }
        return this.getFieldFromClass(parent, fieldName);
    }
}

