/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.AvroUtils;
import com.github.davidmc24.gradle.plugin.avro.FileExtensionSpec;
import com.github.davidmc24.gradle.plugin.avro.FileUtils;
import com.github.davidmc24.gradle.plugin.avro.GradleCompatibility;
import com.github.davidmc24.gradle.plugin.avro.OutputDirTask;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateAvroProtocolTask
extends OutputDirTask {
    private FileCollection classpath = GradleCompatibility.createConfigurableFileCollection(this.getProject());

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    public void classpath(Object ... paths) {
        this.classpath.plus((FileCollection)this.getProject().files(paths));
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    @TaskAction
    protected void process() {
        this.getLogger().info("Found {} files", (Object)this.getSource().getFiles().size());
        this.failOnUnsupportedFiles();
        this.processFiles();
    }

    private void failOnUnsupportedFiles() {
        FileCollection unsupportedFiles = this.filterSources((Spec<? super File>)new NotSpec((Spec)new FileExtensionSpec("avdl")));
        if (!unsupportedFiles.isEmpty()) {
            throw new GradleException(String.format("Unsupported file extension for the following files: %s", unsupportedFiles));
        }
    }

    private void processFiles() {
        int processedFileCount = 0;
        ClassLoader loader = this.assembleClassLoader();
        for (File sourceFile : this.filterSources(new FileExtensionSpec("avdl"))) {
            this.processIDLFile(sourceFile, loader);
            ++processedFileCount;
        }
        this.setDidWork(processedFileCount > 0);
    }

    private void processIDLFile(File idlFile, ClassLoader loader) {
        this.getLogger().info("Processing {}", (Object)idlFile);
        try (Idl idl = new Idl(idlFile, loader);){
            Protocol protocol = idl.CompilationUnit();
            File protoFile = new File(((Directory)this.getOutputDir().get()).getAsFile(), AvroUtils.assemblePath(protocol));
            String protoJson = protocol.toString(true);
            FileUtils.writeJsonFile(protoFile, protoJson);
            this.getLogger().debug("Wrote {}", (Object)protoFile.getPath());
        }
        catch (IOException | ParseException ex) {
            throw new GradleException(String.format("Failed to compile IDL file %s", idlFile), ex);
        }
    }

    private ClassLoader assembleClassLoader() {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (File file : this.classpath) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLogger().debug(e.getMessage());
            }
        }
        if (urls.isEmpty()) {
            this.getLogger().debug("No classpath configured; defaulting to system classloader");
        }
        return urls.isEmpty() ? ClassLoader.getSystemClassLoader() : new URLClassLoader(urls.toArray(new URL[0]), ClassLoader.getSystemClassLoader());
    }
}

