/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import com.github.davidmc24.gradle.plugin.avro.AvroBasePlugin;
import com.github.davidmc24.gradle.plugin.avro.GenerateAvroJavaTask;
import com.github.davidmc24.gradle.plugin.avro.GenerateAvroProtocolTask;
import com.github.davidmc24.gradle.plugin.avro.GradleCompatibility;
import com.github.davidmc24.gradle.plugin.avro.SetBuilder;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.util.Optional;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;

public class AvroPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        project.getPlugins().apply(AvroBasePlugin.class);
        AvroPlugin.configureTasks(project);
        AvroPlugin.configureIntelliJ(project);
    }

    private static void configureTasks(Project project) {
        AvroPlugin.getSourceSets(project).configureEach(sourceSet -> {
            TaskProvider<GenerateAvroProtocolTask> protoTaskProvider = AvroPlugin.configureProtocolGenerationTask(project, sourceSet);
            TaskProvider<GenerateAvroJavaTask> javaTaskProvider = AvroPlugin.configureJavaGenerationTask(project, sourceSet, protoTaskProvider);
            AvroPlugin.configureTaskDependencies(project, sourceSet, javaTaskProvider);
        });
    }

    private static void configureIntelliJ(Project project) {
        project.getPlugins().withType(IdeaPlugin.class).configureEach(ideaPlugin -> {
            SourceSet mainSourceSet = AvroPlugin.getMainSourceSet(project);
            SourceSet testSourceSet = AvroPlugin.getTestSourceSet(project);
            IdeaModule module = ideaPlugin.getModel().getModule();
            module.setSourceDirs(new SetBuilder().addAll(module.getSourceDirs()).add(AvroPlugin.getAvroSourceDir(project, mainSourceSet)).add((File)AvroPlugin.getGeneratedOutputDir(project, mainSourceSet, "java").map(Directory::getAsFile).get()).build());
            GradleCompatibility.addTestSources(module, AvroPlugin.getAvroSourceDir(project, testSourceSet), (File)AvroPlugin.getGeneratedOutputDir(project, testSourceSet, "java").map(Directory::getAsFile).get());
            SetBuilder<File> excludeDirs = new SetBuilder<File>();
            excludeDirs.addAll(module.getExcludeDirs()).remove(project.getBuildDir());
            File buildDir = project.getBuildDir();
            if (buildDir.isDirectory()) {
                excludeDirs.addAll(project.getBuildDir().listFiles(new NonGeneratedDirectoryFileFilter()));
            }
            module.setExcludeDirs(excludeDirs.build());
        });
        project.getTasks().withType(GenerateIdeaModule.class).configureEach(generateIdeaModule -> generateIdeaModule.doFirst(task -> project.getTasks().withType(GenerateAvroJavaTask.class, generateAvroJavaTask -> project.mkdir(generateAvroJavaTask.getOutputDir().get()))));
    }

    private static TaskProvider<GenerateAvroProtocolTask> configureProtocolGenerationTask(Project project, SourceSet sourceSet) {
        String taskName = sourceSet.getTaskName("generate", "avroProtocol");
        return project.getTasks().register(taskName, GenerateAvroProtocolTask.class, task -> {
            task.setDescription(String.format("Generates %s Avro protocol definition files from IDL files.", sourceSet.getName()));
            task.setGroup("Source Generation");
            task.source(new Object[]{AvroPlugin.getAvroSourceDir(project, sourceSet)});
            task.include(new String[]{"**/*.avdl"});
            task.setClasspath((FileCollection)project.getConfigurations().getByName("runtimeClasspath"));
            task.getOutputDir().convention(AvroPlugin.getGeneratedOutputDir(project, sourceSet, "avpr"));
        });
    }

    private static TaskProvider<GenerateAvroJavaTask> configureJavaGenerationTask(Project project, SourceSet sourceSet, TaskProvider<GenerateAvroProtocolTask> protoTaskProvider) {
        String taskName = sourceSet.getTaskName("generate", "avroJava");
        TaskProvider javaTaskProvider = project.getTasks().register(taskName, GenerateAvroJavaTask.class, task -> {
            task.setDescription(String.format("Generates %s Avro Java source files from schema/protocol definition files.", sourceSet.getName()));
            task.setGroup("Source Generation");
            task.source(new Object[]{AvroPlugin.getAvroSourceDir(project, sourceSet)});
            task.source(new Object[]{protoTaskProvider});
            task.include(new String[]{"**/*.avsc", "**/*.avpr"});
            task.getOutputDir().convention(AvroPlugin.getGeneratedOutputDir(project, sourceSet, "java"));
            sourceSet.getJava().srcDir((Object)task.getOutputDir());
            JavaCompile compileJavaTask = (JavaCompile)project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class).get();
            task.getOutputCharacterEncoding().convention(project.provider(() -> Optional.ofNullable(compileJavaTask.getOptions().getEncoding()).orElse(Charset.defaultCharset().name())));
        });
        project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class, compileJavaTask -> compileJavaTask.source(new Object[]{javaTaskProvider}));
        project.getTasks().matching(task -> GradleCompatibility.getSourcesJarTaskName(sourceSet).equals(task.getName())).configureEach(sourcesJarTask -> sourcesJarTask.dependsOn(new Object[]{javaTaskProvider}));
        return javaTaskProvider;
    }

    private static void configureTaskDependencies(Project project, SourceSet sourceSet, TaskProvider<GenerateAvroJavaTask> javaTaskProvider) {
        project.getPluginManager().withPlugin("org.jetbrains.kotlin.jvm", appliedPlugin -> project.getTasks().withType(SourceTask.class).matching(task -> sourceSet.getCompileTaskName("kotlin").equals(task.getName())).configureEach(task -> task.source(new Object[]{((GenerateAvroJavaTask)((Object)((Object)((Object)javaTaskProvider.get())))).getOutputs()})));
    }

    private static File getAvroSourceDir(Project project, SourceSet sourceSet) {
        return project.file((Object)String.format("src/%s/avro", sourceSet.getName()));
    }

    private static Provider<Directory> getGeneratedOutputDir(Project project, SourceSet sourceSet, String extension) {
        String generatedOutputDirName = String.format("generated-%s-avro-%s", sourceSet.getName(), extension);
        return project.getLayout().getBuildDirectory().dir(generatedOutputDirName);
    }

    private static SourceSetContainer getSourceSets(Project project) {
        return (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
    }

    private static SourceSet getMainSourceSet(Project project) {
        return (SourceSet)AvroPlugin.getSourceSets(project).getByName("main");
    }

    private static SourceSet getTestSourceSet(Project project) {
        return (SourceSet)AvroPlugin.getSourceSets(project).getByName("test");
    }

    private static class NonGeneratedDirectoryFileFilter
    implements FileFilter {
        private NonGeneratedDirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith("generated-");
        }
    }
}

