/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmc24.gradle.plugin.avro;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;

class FileState
implements Comparable<FileState> {
    private final File file;
    private final String path;
    private String errorMessage;
    private Set<String> duplicateTypeNames = new TreeSet<String>();

    FileState(File file, String path) {
        this.file = file;
        this.path = path;
    }

    File getFile() {
        return this.file;
    }

    Set<String> getDuplicateTypeNames() {
        return this.duplicateTypeNames;
    }

    void clearError() {
        this.errorMessage = null;
    }

    void setError(Throwable ex) {
        this.errorMessage = ex.getMessage();
    }

    void addDuplicateTypeName(String typeName) {
        this.duplicateTypeNames.add(typeName);
    }

    public boolean containsDuplicateTypeName(String typeName) {
        return this.duplicateTypeNames.contains(typeName);
    }

    public String getPath() {
        return this.path;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int compareTo(FileState o) {
        return this.path.compareTo(o.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileState fileState = (FileState)o;
        return this.path.equals(fileState.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

