/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.apigateway.AmazonApiGateway;
import com.amazonaws.services.apigateway.AmazonApiGatewayClientBuilder;
import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.amazonaws.services.apigateway.model.CreateDeploymentResult;
import com.amazonaws.services.apigateway.model.GetRestApisRequest;
import com.amazonaws.services.apigateway.model.GetRestApisResult;
import com.amazonaws.services.apigateway.model.RestApi;
import com.github.davidmoten.aws.maven.AwsKeyPair;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;

final class ApiGatewayDeployer {
    private final Log log;

    ApiGatewayDeployer(Log log) {
        this.log = log;
    }

    public void deploy(AwsKeyPair keyPair, String region, String restApiName, String stage, Proxy proxy) {
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(keyPair.key, keyPair.secret));
        ClientConfiguration cc = Util.createConfiguration(proxy);
        AmazonApiGateway ag = (AmazonApiGateway)((AmazonApiGatewayClientBuilder)((AmazonApiGatewayClientBuilder)((AmazonApiGatewayClientBuilder)AmazonApiGatewayClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withClientConfiguration(cc)).withRegion(region)).build();
        GetRestApisResult apis = ag.getRestApis(new GetRestApisRequest().withLimit(Integer.valueOf(10000)));
        Optional<RestApi> api = apis.getItems().stream().filter(item -> item.getName().equals(restApiName)).findFirst();
        RestApi a = api.orElseThrow(() -> new RuntimeException("no rest api found with name='" + restApiName + "'"));
        String restApiId = a.getId();
        this.log.info((CharSequence)("creating deployment of " + restApiId + " to stage " + stage));
        CreateDeploymentResult r = ag.createDeployment(new CreateDeploymentRequest().withRestApiId(restApiId).withStageName(stage));
        Map summary = r.getApiSummary();
        this.log.info((CharSequence)"created deployment");
        this.log.info((CharSequence)("summary=" + summary));
    }
}

