/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.github.davidmoten.aws.maven.AwsKeyPair;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="property")
public class AwsPropertyMojo
extends AbstractMojo {
    @Parameter(property="awsAccessKey")
    private String awsAccessKey;
    @Parameter(property="awsSecretAccessKey")
    private String awsSecretAccessKey;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="region")
    private String region;
    @Parameter(property="httpsProxyHost")
    private String httpsProxyHost;
    @Parameter(property="httpsProxyPort")
    private int httpsProxyPort;
    @Parameter(property="httpsProxyUsername")
    private String httpsProxyUsername;
    @Parameter(property="httpsProxyPassword")
    private String httpsProxyPassword;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Proxy proxy = new Proxy(this.httpsProxyHost, this.httpsProxyPort, this.httpsProxyUsername, this.httpsProxyPassword);
        AwsKeyPair keyPair = Util.getAwsKeyPair(this.serverId, this.awsAccessKey, this.awsSecretAccessKey, this.settings, this.decrypter);
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(keyPair.key, keyPair.secret));
        ClientConfiguration cc = Util.createConfiguration(proxy);
        AmazonIdentityManagement iam = (AmazonIdentityManagement)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)((AmazonIdentityManagementClientBuilder)AmazonIdentityManagementClientBuilder.standard().withRegion(this.region)).withCredentials((AWSCredentialsProvider)credentials)).withClientConfiguration(cc)).build();
        String accountId = iam.getUser().getUser().getUserId();
        this.project.getProperties().setProperty("aws.account.id", accountId);
        this.getLog().info((CharSequence)"The following properties have been set for the project");
        this.getLog().info((CharSequence)("aws.account.id=" + accountId));
    }
}

