/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.github.davidmoten.aws.maven.AwsKeyPair;
import com.github.davidmoten.aws.maven.BeanstalkDeployer;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import java.io.File;
import java.util.Date;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="deploy")
public final class BeanstalkDeployMojo
extends AbstractMojo {
    @Parameter(property="awsAccessKey")
    private String awsAccessKey;
    @Parameter(property="awsSecretAccessKey")
    private String awsSecretAccessKey;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="applicationName")
    private String applicationName;
    @Parameter(property="environmentName")
    private String environmentName;
    @Parameter(property="region")
    private String region;
    @Parameter(property="artifact")
    private File artifact;
    @Parameter(property="httpsProxyHost")
    private String httpsProxyHost;
    @Parameter(property="httpsProxyPort")
    private int httpsProxyPort;
    @Parameter(property="httpsProxyUsername")
    private String httpsProxyUsername;
    @Parameter(property="httpsProxyPassword")
    private String httpsProxyPassword;
    @Parameter(property="versionLabel")
    private String versionLabel;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Proxy proxy = new Proxy(this.httpsProxyHost, this.httpsProxyPort, this.httpsProxyUsername, this.httpsProxyPassword);
        if (this.versionLabel == null) {
            this.versionLabel = BeanstalkDeployMojo.createVersionLabel(this.applicationName, new Date(), this.project.getVersion());
        }
        BeanstalkDeployer deployer = new BeanstalkDeployer(this.getLog());
        AwsKeyPair keyPair = Util.getAwsKeyPair(this.serverId, this.awsAccessKey, this.awsSecretAccessKey, this.settings, this.decrypter);
        deployer.deploy(this.artifact, keyPair, this.region, this.applicationName, this.environmentName, this.versionLabel, proxy);
    }

    private static String createVersionLabel(String applicationName, Date date, String version) {
        return applicationName + "_" + version + "_" + Util.formatDateTime(date);
    }
}

