/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.github.davidmoten.aws.maven.AwsKeyPair;
import com.github.davidmoten.aws.maven.CloudFormationDeployer;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="deployCf")
public final class CloudFormationDeployMojo
extends AbstractMojo {
    @Parameter(property="awsAccessKey")
    private String awsAccessKey;
    @Parameter(property="awsSecretAccessKey")
    private String awsSecretAccessKey;
    @Parameter(property="region")
    private String region;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="stackName")
    private String stackName;
    @Parameter(property="parameters")
    private Map<String, String> parameters;
    @Parameter(property="stackTemplate")
    private File template;
    @Parameter(property="intervalSeconds", defaultValue="5")
    private int intervalSeconds;
    @Parameter(property="httpsProxyHost")
    private String httpsProxyHost;
    @Parameter(property="httpsProxyPort")
    private int httpsProxyPort;
    @Parameter(property="httpsProxyUsername")
    private String httpsProxyUsername;
    @Parameter(property="httpsProxyPassword")
    private String httpsProxyPassword;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        byte[] bytes;
        Proxy proxy = new Proxy(this.httpsProxyHost, this.httpsProxyPort, this.httpsProxyUsername, this.httpsProxyPassword);
        CloudFormationDeployer deployer = new CloudFormationDeployer(this.getLog());
        AwsKeyPair keys = Util.getAwsKeyPair(this.serverId, this.awsAccessKey, this.awsSecretAccessKey, this.settings, this.decrypter);
        try {
            bytes = Files.readAllBytes(this.template.toPath());
        }
        catch (IOException e) {
            throw new MojoFailureException("could not read template=" + this.template + ": " + e.getMessage(), (Throwable)e);
        }
        String templateBody = new String(bytes, StandardCharsets.UTF_8);
        deployer.deploy(keys, this.region, this.stackName, templateBody, this.parameters, this.intervalSeconds, proxy);
    }
}

