/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClientBuilder;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.github.davidmoten.aws.maven.AwsKeyPair;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

class LambdaDeployer {
    private final Log log;

    LambdaDeployer(Log log) {
        this.log = log;
    }

    void deploy(AwsKeyPair keyPair, String region, String zipFilename, String functionName, Proxy proxy) {
        byte[] bytes;
        long t = System.currentTimeMillis();
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(keyPair.key, keyPair.secret));
        AWSLambda lambda = (AWSLambda)((AWSLambdaClientBuilder)((AWSLambdaClientBuilder)((AWSLambdaClientBuilder)AWSLambdaClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withClientConfiguration(Util.createConfiguration(proxy))).withRegion(region)).build();
        try {
            bytes = IOUtils.toByteArray((InputStream)new FileInputStream(zipFilename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DecimalFormat df = new DecimalFormat("0.000");
        this.log.info((CharSequence)("deploying " + zipFilename + ", length=" + df.format((double)bytes.length / 1024.0 / 1024.0) + "MB, to functionName=" + functionName));
        lambda.updateFunctionCode(new UpdateFunctionCodeRequest().withFunctionName(functionName).withPublish(Boolean.valueOf(true)).withZipFile(ByteBuffer.wrap(bytes)));
        this.log.info((CharSequence)("deployed in " + (System.currentTimeMillis() - t) + "ms"));
    }
}

