/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.github.davidmoten.aws.maven.AwsKeyPair;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.maven.plugin.logging.Log;

final class S3Deployer {
    private final Log log;

    S3Deployer(Log log) {
        this.log = log;
    }

    public void deploy(AwsKeyPair keyPair, String region, String inputDirectory, final String bucketName, final String outputBasePath, Proxy proxy) {
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(keyPair.key, keyPair.secret));
        ClientConfiguration cc = Util.createConfiguration(proxy);
        final AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withClientConfiguration(cc)).withRegion(region)).build();
        if (inputDirectory == null) {
            throw new RuntimeException("must specify inputDirectory parameter in configuration");
        }
        final Path root = new File(inputDirectory).toPath().toAbsolutePath();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    AccessControlList acl = new AccessControlList();
                    acl.grantPermission((Grantee)GroupGrantee.AllUsers, Permission.Read);
                    String relativePath = root.relativize(file.toAbsolutePath()).toString();
                    String objectName = outputBasePath != null ? outputBasePath + "/" + relativePath : relativePath;
                    S3Deployer.this.log.info((CharSequence)("uploading " + file.toFile() + " to " + bucketName + ":" + objectName));
                    PutObjectRequest req = new PutObjectRequest(bucketName, objectName, file.toFile()).withAccessControlList(acl);
                    s3.putObject(req);
                    return FileVisitResult.CONTINUE;
                }
            });
            this.log.info((CharSequence)"uploaded files");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

