/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.github.davidmoten.aws.maven.AwsKeyPair;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import java.io.File;
import org.apache.maven.plugin.logging.Log;

final class S3FileDeployer {
    private final Log log;

    S3FileDeployer(Log log) {
        this.log = log;
    }

    public void deploy(AwsKeyPair keyPair, String region, File file, String bucketName, String objectName, Proxy proxy, boolean create) {
        if (file == null) {
            throw new RuntimeException("must specify inputDirectory parameter in configuration");
        }
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(keyPair.key, keyPair.secret));
        ClientConfiguration cc = Util.createConfiguration(proxy);
        AmazonS3 s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withClientConfiguration(cc)).withRegion(region)).build();
        if (create && !s3.doesBucketExistV2(bucketName)) {
            this.log.info((CharSequence)"bucket does not exist so creating");
            s3.createBucket(bucketName);
            this.log.info((CharSequence)("created bucket " + bucketName));
        }
        PutObjectRequest req = new PutObjectRequest(bucketName, objectName, file);
        this.log.info((CharSequence)("uploading object to s3:" + bucketName + ":" + objectName + ", " + file.length() + " bytes"));
        s3.putObject(req);
        this.log.info((CharSequence)("deployed " + file.getName() + " to s3 " + bucketName + ":" + objectName));
    }
}

