/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.davidmoten.aws.maven.AbstractAwsMojo;
import com.github.davidmoten.aws.maven.BeanstalkDeployer;
import com.github.davidmoten.aws.maven.Proxy;
import com.github.davidmoten.aws.maven.Util;
import java.io.File;
import java.util.Date;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy")
public final class BeanstalkDeployMojo
extends AbstractAwsMojo {
    @Parameter(property="applicationName")
    private String applicationName;
    @Parameter(property="environmentName")
    private String environmentName;
    @Parameter(property="artifact")
    private File artifact;
    @Parameter(property="versionLabel")
    private String versionLabel;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;

    @Override
    protected void execute(AWSCredentialsProvider credentials, String region, Proxy proxy) {
        if (this.versionLabel == null) {
            this.versionLabel = BeanstalkDeployMojo.createVersionLabel(this.applicationName, new Date(), this.project.getVersion());
        }
        ClientConfiguration clientConfiguration = Util.createConfiguration(proxy);
        AWSElasticBeanstalk beanstalkClient = (AWSElasticBeanstalk)((AWSElasticBeanstalkClientBuilder)((AWSElasticBeanstalkClientBuilder)((AWSElasticBeanstalkClientBuilder)AWSElasticBeanstalkClientBuilder.standard().withRegion(region)).withCredentials(credentials)).withClientConfiguration(clientConfiguration)).build();
        AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(region)).withCredentials(credentials)).withClientConfiguration(clientConfiguration)).build();
        BeanstalkDeployer deployer = new BeanstalkDeployer(this.getLog(), beanstalkClient, s3Client);
        deployer.deploy(this.artifact, this.applicationName, this.environmentName, this.versionLabel);
    }

    private static String createVersionLabel(String applicationName, Date date, String version) {
        return applicationName + "_" + version + "_" + Util.formatDateTime(date);
    }
}

