/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.s3.AmazonS3;
import org.apache.maven.plugin.logging.Log;

final class S3Bucket {
    private final Log log;
    private final AmazonS3 s3Client;

    S3Bucket(Log log, AmazonS3 s3Client) {
        this.log = log;
        this.s3Client = s3Client;
    }

    void create(String bucketName) {
        if (!this.s3Client.doesBucketExistV2(bucketName)) {
            this.log.info((CharSequence)"bucket does not exist so creating");
            this.s3Client.createBucket(bucketName);
            this.log.info((CharSequence)("created bucket " + bucketName));
        } else {
            this.log.info((CharSequence)("bucket " + bucketName + " already exists, skipping create"));
        }
    }
}

