/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.maven.plugin.logging.Log;

final class S3Deployer {
    private final Log log;
    private final AmazonS3 s3Client;

    S3Deployer(Log log, AmazonS3 s3Client) {
        this.log = log;
        this.s3Client = s3Client;
    }

    public void deploy(String inputDirectory, final String bucketName, final String outputBasePath, final boolean publicRead) {
        if (inputDirectory == null) {
            throw new RuntimeException("must specify inputDirectory parameter in configuration");
        }
        final Path root = new File(inputDirectory).toPath().toAbsolutePath();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relativePath = root.relativize(file.toAbsolutePath()).toString();
                    String objectName = outputBasePath != null ? outputBasePath + "/" + relativePath : relativePath;
                    S3Deployer.this.log.info((CharSequence)("uploading " + file.toFile() + " to " + bucketName + ":" + objectName));
                    PutObjectRequest req = new PutObjectRequest(bucketName, objectName, file.toFile());
                    if (publicRead) {
                        AccessControlList acl = new AccessControlList();
                        acl.grantPermission((Grantee)GroupGrantee.AllUsers, Permission.Read);
                        req = req.withAccessControlList(acl);
                    }
                    S3Deployer.this.s3Client.putObject(req);
                    return FileVisitResult.CONTINUE;
                }
            });
            this.log.info((CharSequence)"uploaded files");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

