/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import java.io.File;
import org.apache.maven.plugin.logging.Log;

final class S3FileDeployer {
    private final Log log;
    private final AmazonS3 s3Client;

    S3FileDeployer(Log log, AmazonS3 s3Client) {
        this.log = log;
        this.s3Client = s3Client;
    }

    public void deploy(File file, String bucketName, String objectName, boolean create, String awsKmsKeyId) {
        if (file == null) {
            throw new RuntimeException("must specify inputDirectory parameter in configuration");
        }
        if (create && !this.s3Client.doesBucketExistV2(bucketName)) {
            this.log.info((CharSequence)"bucket does not exist so creating");
            this.s3Client.createBucket(bucketName);
            this.log.info((CharSequence)("created bucket " + bucketName));
        }
        PutObjectRequest req = awsKmsKeyId != null ? new PutObjectRequest(bucketName, objectName, file).withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(awsKmsKeyId)) : new PutObjectRequest(bucketName, objectName, file);
        this.log.info((CharSequence)("uploading object to s3:" + bucketName + ":" + objectName + ", " + file.length() + " bytes"));
        this.s3Client.putObject(req);
        this.log.info((CharSequence)("deployed " + file.getName() + " to s3 " + bucketName + ":" + objectName));
    }
}

