/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.github.davidmoten.aws.maven.Proxy;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;

abstract class AbstractAwsMojo
extends AbstractMojo {
    private static final String REGION_NOT_FOUND_ERROR_MESSAGE = "The region must be specified either in the plugin configuration (region), environment variable (AWS_REGION), system property (aws.region), AWS shared configuration file or instance metadata.";
    private static final String CREDENTIALS_NOT_FOUND_ERROR_MESSAGE = "The AWS access key and AWS secret access key must be specified either in Maven server authentication profile (by specifying serverId in the plugin configuration), plugin configuration (awsAccessKey and awsSecretAccessKey), environment variables (AWS_ACCESS_KEY_ID and AWS_SECRET_ACCESS_KEY), system properties (aws.accessKeyId and aws.secretKey), default credential profiles file, ECS container credentials or instance profile credentials";
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    @Parameter(property="awsAccessKey")
    private String awsAccessKey;
    @Parameter(property="awsSecretAccessKey")
    private String awsSecretAccessKey;
    @Parameter(property="region")
    private String region;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="httpsProxyHost")
    private String httpsProxyHost;
    @Parameter(property="httpsProxyPort")
    private int httpsProxyPort;
    @Parameter(property="httpsProxyUsername")
    private String httpsProxyUsername;
    @Parameter(property="httpsProxyPassword")
    private String httpsProxyPassword;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;

    AbstractAwsMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        String region = this.getRegion().orElseThrow(() -> new MojoExecutionException(REGION_NOT_FOUND_ERROR_MESSAGE));
        AWSCredentialsProvider credentials = this.getAwsCredentialsProvider().orElseThrow(() -> new MojoExecutionException(CREDENTIALS_NOT_FOUND_ERROR_MESSAGE));
        Proxy proxy = new Proxy(this.httpsProxyHost, this.httpsProxyPort, this.httpsProxyUsername, this.httpsProxyPassword);
        this.execute(credentials, region, proxy);
    }

    private Optional<String> getRegion() {
        String region;
        if (this.region != null) {
            return Optional.of(this.region);
        }
        try {
            region = DEFAULT_REGION_PROVIDER.getRegion();
        }
        catch (SdkClientException e) {
            region = null;
        }
        return Optional.ofNullable(region);
    }

    private Optional<AWSCredentialsProvider> getAwsCredentialsProvider() {
        AWSCredentials awsCredentials = null;
        if (this.serverId != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server != null) {
                DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
                Server decryptedServer = this.decrypter.decrypt((SettingsDecryptionRequest)request).getServer();
                awsCredentials = new BasicAWSCredentials(decryptedServer.getUsername(), decryptedServer.getPassword());
            } else {
                this.getLog().warn((CharSequence)("Unable to find the server with the following id in the settings: " + this.serverId));
            }
        }
        if (awsCredentials == null && this.awsAccessKey != null && this.awsSecretAccessKey != null) {
            awsCredentials = new BasicAWSCredentials(this.awsAccessKey, this.awsSecretAccessKey);
        }
        if (awsCredentials == null) {
            try {
                awsCredentials = DefaultAWSCredentialsProviderChain.getInstance().getCredentials();
            }
            catch (SdkClientException sdkClientException) {
                // empty catch block
            }
        }
        return Optional.ofNullable(awsCredentials).map(AWSStaticCredentialsProvider::new);
    }

    protected abstract void execute(AWSCredentialsProvider var1, String var2, Proxy var3) throws MojoExecutionException, MojoFailureException;
}

