/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.apigateway.AmazonApiGateway;
import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.amazonaws.services.apigateway.model.CreateDeploymentResult;
import com.amazonaws.services.apigateway.model.GetRestApisRequest;
import com.amazonaws.services.apigateway.model.GetRestApisResult;
import com.amazonaws.services.apigateway.model.RestApi;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;

final class ApiGatewayDeployer {
    private final Log log;
    private final AmazonApiGateway apiGatewayClient;

    ApiGatewayDeployer(Log log, AmazonApiGateway apiGatewayClient) {
        this.log = log;
        this.apiGatewayClient = apiGatewayClient;
    }

    void deploy(String restApiName, String stage) {
        GetRestApisResult apis = this.apiGatewayClient.getRestApis(new GetRestApisRequest().withLimit(Integer.valueOf(10000)));
        Optional<RestApi> api = apis.getItems().stream().filter(item -> item.getName().equals(restApiName)).findFirst();
        RestApi a = api.orElseThrow(() -> new RuntimeException("no rest api found with name='" + restApiName + "'"));
        String restApiId = a.getId();
        this.log.info((CharSequence)("creating deployment of " + restApiId + " to stage " + stage));
        CreateDeploymentResult r = this.apiGatewayClient.createDeployment(new CreateDeploymentRequest().withRestApiId(restApiId).withStageName(stage));
        Map summary = r.getApiSummary();
        this.log.info((CharSequence)"created deployment");
        this.log.info((CharSequence)("summary=" + summary));
    }
}

