/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.github.davidmoten.aws.maven.AbstractDeployAwsMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="property")
public class AwsPropertyMojo
extends AbstractDeployAwsMojo<AmazonIdentityManagementClientBuilder, AmazonIdentityManagement> {
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;

    public AwsPropertyMojo() {
        super(AmazonIdentityManagementClientBuilder.standard());
    }

    @Override
    protected void execute(AmazonIdentityManagement identityManagementClient) {
        String accountId = identityManagementClient.getUser().getUser().getUserId();
        this.project.getProperties().setProperty("aws.account.id", accountId);
        this.project.getProperties().setProperty("aws.account.id.lowercase", accountId.toLowerCase());
        this.getLog().info((CharSequence)"The following properties have been set for the project");
        this.getLog().info((CharSequence)("aws.account.id=" + accountId));
        this.getLog().info((CharSequence)("aws.account.id.lowercase=" + accountId.toLowerCase()));
    }
}

