/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.github.davidmoten.aws.maven.Util;
import java.io.File;
import java.util.Date;
import org.apache.maven.plugin.logging.Log;

final class BeanstalkDeployer {
    private final Log log;
    private final AWSElasticBeanstalk beanstalkClient;
    private final AmazonS3 s3Client;

    BeanstalkDeployer(Log log, AWSElasticBeanstalk beanstalkClient, AmazonS3 s3Client) {
        this.log = log;
        this.beanstalkClient = beanstalkClient;
        this.s3Client = s3Client;
    }

    void deploy(File artifact, String applicationName, String environmentName, String versionLabel) {
        String bucketName = this.getS3BucketName();
        String dateTime = Util.formatDateTime(new Date());
        String objectName = artifact.getName() + "_" + dateTime;
        this.uploadArtifact(artifact, bucketName, objectName);
        this.createApplicationVersion(applicationName, this.beanstalkClient, bucketName, objectName, versionLabel);
        this.updateEnvironment(applicationName, environmentName, this.beanstalkClient, versionLabel);
    }

    private String getS3BucketName() {
        this.log.info((CharSequence)"getting s3 bucket name to deploy artifact to");
        String bucketName = this.beanstalkClient.createStorageLocation().getS3Bucket();
        this.log.info((CharSequence)("s3Bucket=" + bucketName));
        return bucketName;
    }

    private void uploadArtifact(File artifact, String bucketName, String objectName) {
        this.log.info((CharSequence)("uploading " + artifact + " to " + bucketName + ":" + objectName));
        this.s3Client.putObject(bucketName, objectName, artifact);
    }

    private void createApplicationVersion(String applicationName, AWSElasticBeanstalk eb, String bucketName, String objectName, String versionLabel) {
        this.log.info((CharSequence)("creating version label=" + versionLabel));
        CreateApplicationVersionRequest request = new CreateApplicationVersionRequest().withApplicationName(applicationName).withAutoCreateApplication(Boolean.valueOf(true)).withSourceBundle(new S3Location(bucketName, objectName)).withVersionLabel(versionLabel);
        eb.createApplicationVersion(request);
    }

    private void updateEnvironment(String applicationName, String environmentName, AWSElasticBeanstalk eb, String versionLabel) {
        this.log.info((CharSequence)"requesting update of environment to new version label");
        UpdateEnvironmentRequest request = new UpdateEnvironmentRequest().withApplicationName(applicationName).withEnvironmentName(environmentName).withVersionLabel(versionLabel);
        eb.updateEnvironment(request);
        this.log.info((CharSequence)"requested");
    }
}

