/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClientBuilder;
import com.github.davidmoten.aws.maven.AbstractDeployAwsMojo;
import com.github.davidmoten.aws.maven.CloudFormationDeployer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deployCf")
public final class CloudFormationDeployMojo
extends AbstractDeployAwsMojo<AmazonCloudFormationClientBuilder, AmazonCloudFormation> {
    @Parameter(property="stackName")
    private String stackName;
    @Parameter(property="parameters")
    private Map<String, String> parameters;
    @Parameter(property="stackTemplate")
    private File template;
    @Parameter(property="templateUrl")
    private String templateUrl;
    @Parameter(property="intervalSeconds", defaultValue="5")
    private int intervalSeconds;

    public CloudFormationDeployMojo() {
        super(AmazonCloudFormationClientBuilder.standard());
    }

    @Override
    protected void execute(AmazonCloudFormation cloudFormationClient) throws MojoFailureException {
        byte[] bytes;
        if (this.templateUrl == null) {
            try {
                bytes = Files.readAllBytes(this.template.toPath());
            }
            catch (IOException e) {
                throw new MojoFailureException("could not read template=" + this.template + ": " + e.getMessage(), (Throwable)e);
            }
        } else {
            bytes = new byte[]{};
        }
        String templateBody = new String(bytes, StandardCharsets.UTF_8);
        CloudFormationDeployer deployer = new CloudFormationDeployer(this.getLog(), cloudFormationClient);
        deployer.deploy(this.stackName, templateBody, this.parameters, this.intervalSeconds, this.templateUrl);
    }
}

