/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.CreateAliasRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;

class LambdaDeployer {
    private final Log log;
    private final AWSLambda lambdaClient;

    LambdaDeployer(Log log, AWSLambda lambdaClient) {
        this.log = log;
        this.lambdaClient = lambdaClient;
    }

    void deploy(String zipFilename, String functionName, String functionAlias) {
        byte[] bytes;
        long t = System.currentTimeMillis();
        try {
            bytes = IOUtils.toByteArray((InputStream)new FileInputStream(zipFilename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DecimalFormat df = new DecimalFormat("0.000");
        this.log.info((CharSequence)("deploying " + zipFilename + ", length=" + df.format((double)bytes.length / 1024.0 / 1024.0) + "MB, to functionName=" + functionName));
        UpdateFunctionCodeResult updateFunctionCodeResult = this.lambdaClient.updateFunctionCode(new UpdateFunctionCodeRequest().withFunctionName(functionName).withPublish(Boolean.valueOf(true)).withZipFile(ByteBuffer.wrap(bytes)));
        this.log.info((CharSequence)("deployed in " + (System.currentTimeMillis() - t) + "ms"));
        Optional<String> optionalFunctionAlias = Optional.ofNullable(functionAlias);
        if (optionalFunctionAlias.isPresent()) {
            String sanitisedFunctionAlias = LambdaDeployer.sanitizeFunctionAlias(optionalFunctionAlias.get());
            this.lambdaClient.createAlias(new CreateAliasRequest().withFunctionVersion(updateFunctionCodeResult.getVersion()).withFunctionName(functionName).withName(sanitisedFunctionAlias));
            this.log.info((CharSequence)("created alias=" + sanitisedFunctionAlias + " to functionName=" + functionName + " for version=" + updateFunctionCodeResult.getVersion()));
        }
    }

    @VisibleForTesting
    static String sanitizeFunctionAlias(String functionAlias) {
        Preconditions.checkNotNull((Object)functionAlias);
        return functionAlias.replaceAll("[-\\.]", "_").replaceAll(":", "");
    }
}

